/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import com.google.common.collect.Maps;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.writer.commands.BaseJdbcBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataBufferedInserter
extends BaseJdbcBufferedInserter {
    private static final Logger LOG = LoggerFactory.getLogger(TeradataBufferedInserter.class);
    private Map<Integer, Integer> columnPosSqlTypes;

    public TeradataBufferedInserter(State state, Connection conn) {
        super(state, conn);
    }

    @Override
    protected boolean insertBatch(PreparedStatement pstmt) throws SQLException {
        int[] execStatus;
        for (JdbcEntryData pendingEntry : this.pendingInserts) {
            int i = 1;
            for (JdbcEntryDatum datum : pendingEntry) {
                Object value = datum.getVal();
                if (value != null) {
                    pstmt.setObject(i, value);
                } else {
                    pstmt.setNull(i, this.columnPosSqlTypes.get(i));
                }
                ++i;
            }
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing SQL " + pstmt);
        }
        for (int status : execStatus = pstmt.executeBatch()) {
            if (status != -3) continue;
            throw new BatchUpdateException("Batch insert failed.", execStatus);
        }
        return true;
    }

    @Override
    protected String createPrepareStatementStr(int batchSize) {
        String VALUE_FORMAT = "(%s)";
        StringBuilder sb = new StringBuilder(this.insertStmtPrefix);
        String values = String.format("(%s)", JOINER_ON_COMMA.useForNull("?").join((Object[])new String[this.columnNames.size()]));
        sb.append(values);
        return sb.append(';').toString();
    }

    @Override
    protected void initializeBatch(String databaseName, String table) throws SQLException {
        super.initializeBatch(databaseName, table);
        this.columnPosSqlTypes = this.getColumnPosSqlTypes();
    }

    private Map<Integer, Integer> getColumnPosSqlTypes() {
        try {
            HashMap columnPosSqlTypes = Maps.newHashMap();
            ParameterMetaData pMetaData = this.insertPstmtForFixedBatch.getParameterMetaData();
            for (int i = 1; i <= pMetaData.getParameterCount(); ++i) {
                columnPosSqlTypes.put(i, pMetaData.getParameterType(i));
            }
            return columnPosSqlTypes;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot retrieve columns types for batch insert", e);
        }
    }

    @Override
    public String toString() {
        return "TeradataBufferedInserter(columnPosSqlTypes=" + this.getColumnPosSqlTypes() + ")";
    }
}

