/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.writer.commands.BaseJdbcBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresBufferedInserter
extends BaseJdbcBufferedInserter {
    private static final Logger log = LoggerFactory.getLogger(PostgresBufferedInserter.class);

    public PostgresBufferedInserter(State state, Connection conn) {
        super(state, conn);
    }

    @Override
    protected String createPrepareStatementStr(int batchSize) {
        String VALUE_FORMAT = "(%s)";
        StringBuilder sb = new StringBuilder(this.insertStmtPrefix);
        String values = String.format("(%s)", JOINER_ON_COMMA.useForNull("?").join((Object[])new String[this.columnNames.size()]));
        sb.append(values);
        for (int i = 1; i < batchSize; ++i) {
            sb.append(',').append(values);
        }
        return sb.append(';').toString();
    }

    @Override
    protected boolean insertBatch(PreparedStatement pstmt) throws SQLException {
        int i = 0;
        pstmt.clearParameters();
        for (JdbcEntryData pendingEntry : this.pendingInserts) {
            for (JdbcEntryDatum datum : pendingEntry) {
                pstmt.setObject(++i, datum.getVal());
            }
        }
        log.debug("Executing SQL " + pstmt);
        return pstmt.execute();
    }
}

