/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.writer.commands.BaseJdbcBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlBufferedInserter
extends BaseJdbcBufferedInserter {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlBufferedInserter.class);
    protected static final String REPLACE_STATEMENT_PREFIX_FORMAT = "REPLACE INTO %s.%s (%s) VALUES ";
    private final int maxParamSize;
    private final boolean overwriteRecords;

    public MySqlBufferedInserter(State state, Connection conn, boolean overwriteRecords) {
        super(state, conn);
        this.maxParamSize = state.getPropAsInt("writer.jdbc.insert_max_param_size", 100000);
        this.overwriteRecords = overwriteRecords;
    }

    @Override
    protected boolean insertBatch(PreparedStatement pstmt) throws SQLException {
        int i = 0;
        pstmt.clearParameters();
        for (JdbcEntryData pendingEntry : this.pendingInserts) {
            for (JdbcEntryDatum datum : pendingEntry) {
                pstmt.setObject(++i, datum.getVal());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing SQL " + pstmt);
        }
        return pstmt.execute();
    }

    @Override
    protected String createPrepareStatementStr(int batchSize) {
        String VALUE_FORMAT = "(%s)";
        StringBuilder sb = new StringBuilder(this.insertStmtPrefix);
        String values = String.format("(%s)", JOINER_ON_COMMA.useForNull("?").join((Object[])new String[this.columnNames.size()]));
        sb.append(values);
        for (int i = 1; i < batchSize; ++i) {
            sb.append(',').append(values);
        }
        return sb.append(';').toString();
    }

    @Override
    protected void initializeBatch(String databaseName, String table) throws SQLException {
        int actualBatchSize = Math.min(this.batchSize, this.maxParamSize / this.columnNames.size());
        if (this.batchSize != actualBatchSize) {
            LOG.info("Changing batch size from " + this.batchSize + " to " + actualBatchSize + " due to # of params limitation " + this.maxParamSize + " , # of columns: " + this.columnNames.size());
        }
        this.batchSize = actualBatchSize;
        super.initializeBatch(databaseName, table);
    }

    @Override
    protected String createInsertStatementStr(String databaseName, String table) {
        return String.format(this.overwriteRecords ? REPLACE_STATEMENT_PREFIX_FORMAT : "INSERT INTO %s.%s (%s) VALUES ", databaseName, table, JOINER_ON_COMMA.join((Iterable)this.columnNames));
    }

    @Override
    public String toString() {
        return "MySqlBufferedInserter(maxParamSize=" + this.maxParamSize + ", overwriteRecords=" + this.overwriteRecords + ")";
    }
}

