/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.writer.commands.BaseJdbcBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJdbcBufferedInserter
extends BaseJdbcBufferedInserter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericJdbcBufferedInserter.class);
    private static final String INSERT_STATEMENT_PREFIX_FORMAT = "INSERT INTO %s.%s (%s) VALUES  (%s)";
    private final int maxParamSize;
    private int currBatchSize;

    public GenericJdbcBufferedInserter(State state, Connection conn) {
        super(state, conn);
        this.maxParamSize = state.getPropAsInt("writer.jdbc.insert_max_param_size", 100000);
    }

    @Override
    protected boolean insertBatch(PreparedStatement pstmt) throws SQLException {
        this.insertPstmtForFixedBatch.executeBatch();
        return true;
    }

    @Override
    public void insert(String databaseName, String table, JdbcEntryData jdbcEntryData) throws SQLException {
        if (this.insertPstmtForFixedBatch == null) {
            for (JdbcEntryDatum datum : jdbcEntryData) {
                this.columnNames.add(datum.getColumnName());
            }
            this.initializeBatch(databaseName, table);
        }
        int i = 0;
        for (JdbcEntryDatum datum : jdbcEntryData) {
            this.insertPstmtForFixedBatch.setObject(++i, datum.getVal());
        }
        this.insertPstmtForFixedBatch.addBatch();
        ++this.currBatchSize;
        if (this.currBatchSize >= this.batchSize) {
            this.executeBatchInsert(this.insertPstmtForFixedBatch);
        }
    }

    @Override
    protected void initializeBatch(String databaseName, String table) throws SQLException {
        int actualBatchSize = Math.min(this.batchSize, this.maxParamSize / this.columnNames.size());
        if (this.batchSize != actualBatchSize) {
            LOG.info("Changing batch size from " + this.batchSize + " to " + actualBatchSize + " due to # of params limitation " + this.maxParamSize + " , # of columns: " + this.columnNames.size());
        }
        this.batchSize = actualBatchSize;
        super.initializeBatch(databaseName, table);
    }

    @Override
    protected String createInsertStatementStr(String databaseName, String table) {
        return String.format(INSERT_STATEMENT_PREFIX_FORMAT, databaseName, table, JOINER_ON_COMMA.join((Iterable)this.columnNames), JOINER_ON_COMMA.useForNull("?").join((Object[])new String[this.columnNames.size()]));
    }

    @Override
    protected void resetBatch() {
        try {
            this.insertPstmtForFixedBatch.clearBatch();
            this.insertPstmtForFixedBatch.clearParameters();
            this.currBatchSize = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() throws SQLException {
        if (this.currBatchSize > 0) {
            this.insertBatch(this.insertPstmtForFixedBatch);
        }
    }

    @Override
    protected String createPrepareStatementStr(int batchSize) {
        return null;
    }
}

