/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.commands;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.writer.commands.JdbcBufferedInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJdbcBufferedInserter
implements JdbcBufferedInserter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseJdbcBufferedInserter.class);
    protected static final String INSERT_STATEMENT_PREFIX_FORMAT = "INSERT INTO %s.%s (%s) VALUES ";
    protected static final Joiner JOINER_ON_COMMA = Joiner.on((char)',');
    protected final Connection conn;
    protected final List<JdbcEntryData> pendingInserts = Lists.newArrayList();
    protected final List<String> columnNames = Lists.newArrayList();
    protected int batchSize;
    protected String insertStmtPrefix;
    protected PreparedStatement insertPstmtForFixedBatch;
    private final Retryer<Boolean> retryer;

    public BaseJdbcBufferedInserter(State state, Connection conn) {
        this.conn = conn;
        this.batchSize = state.getPropAsInt("writer.jdbc.batch_size", 30);
        if (this.batchSize < 1) {
            throw new IllegalArgumentException("writer.jdbc.batch_size should be a positive number");
        }
        int maxWait = state.getPropAsInt("writer.jdbc.insert_retry_timeout", 30);
        int maxAttempts = state.getPropAsInt("writer.jdbc.insert_retry_max_attempt", 5);
        this.retryer = RetryerBuilder.newBuilder().retryIfException().withWaitStrategy(WaitStrategies.exponentialWait((long)1000L, (long)maxWait, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxAttempts)).build();
    }

    protected abstract boolean insertBatch(PreparedStatement var1) throws SQLException;

    protected abstract String createPrepareStatementStr(int var1);

    @Override
    public void insert(String databaseName, String table, JdbcEntryData jdbcEntryData) throws SQLException {
        if (this.columnNames.isEmpty()) {
            for (JdbcEntryDatum datum : jdbcEntryData) {
                this.columnNames.add(datum.getColumnName());
            }
            this.initializeBatch(databaseName, table);
        }
        this.pendingInserts.add(jdbcEntryData);
        if (this.pendingInserts.size() == this.batchSize) {
            this.executeBatchInsert(this.insertPstmtForFixedBatch);
        }
    }

    protected void initializeBatch(String databaseName, String table) throws SQLException {
        this.insertStmtPrefix = this.createInsertStatementStr(databaseName, table);
        this.insertPstmtForFixedBatch = this.conn.prepareStatement(this.createPrepareStatementStr(this.batchSize));
        LOG.info(String.format("Initialized for %s insert " + this, this.batchSize > 1 ? "batch" : ""));
    }

    protected void executeBatchInsert(final PreparedStatement pstmt) {
        try {
            this.retryer.wrap((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return BaseJdbcBufferedInserter.this.insertBatch(pstmt);
                }
            }).call();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to insert.", e);
        }
        this.resetBatch();
    }

    protected void resetBatch() {
        this.pendingInserts.clear();
    }

    protected String createInsertStatementStr(String databaseName, String table) {
        return String.format(INSERT_STATEMENT_PREFIX_FORMAT, databaseName, table, JOINER_ON_COMMA.join(this.columnNames));
    }

    @Override
    public void flush() throws SQLException {
        if (this.pendingInserts == null || this.pendingInserts.isEmpty()) {
            return;
        }
        try (PreparedStatement pstmt = this.conn.prepareStatement(this.createPrepareStatementStr(this.pendingInserts.size()));){
            this.insertBatch(pstmt);
        }
    }

    public String toString() {
        return "BaseJdbcBufferedInserter(conn=" + this.conn + ", pendingInserts=" + this.pendingInserts + ", columnNames=" + this.columnNames + ", batchSize=" + this.batchSize + ", insertStmtPrefix=" + this.insertStmtPrefix + ", insertPstmtForFixedBatch=" + this.insertPstmtForFixedBatch + ", retryer=" + this.retryer + ")";
    }
}

