/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.jdbc.JdbcCommand;
import org.apache.gobblin.source.jdbc.JdbcExtractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerExtractor
extends JdbcExtractor {
    private static final Logger log = LoggerFactory.getLogger(SqlServerExtractor.class);
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String HOUR_FORMAT = "HH";
    private static final long SAMPLERECORDCOUNT = -1L;

    public SqlServerExtractor(WorkUnitState workUnitState) {
        super(workUnitState);
    }

    @Override
    public String getLeftDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "[" : "";
    }

    @Override
    public String getRightDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "]" : "";
    }

    public List<Command> getSchemaMetadata(String schema, String entity) throws SchemaException {
        log.debug("Build query to get schema");
        ArrayList<Command> commands = new ArrayList<Command>();
        List<String> queryParams = Arrays.asList(entity, schema);
        String metadataSql = "select  col.column_name,  col.data_type,  case when CHARACTER_OCTET_LENGTH is null then 0 else 0 end as length,  case when NUMERIC_PRECISION is null then 0 else NUMERIC_PRECISION end as precesion,  case when NUMERIC_SCALE is null then 0 else NUMERIC_SCALE end as scale,  case when is_nullable='NO' then 'false' else 'true' end as nullable,  '' as format,  '' as comment  from information_schema.COLUMNS col  WHERE upper(col.table_name)=upper(?) AND upper(col.table_schema)=upper(?)  order by col.ORDINAL_POSITION ";
        commands.add(JdbcExtractor.getCommand(metadataSql, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(JdbcExtractor.getCommand(queryParams, JdbcCommand.JdbcCommandType.QUERYPARAMS));
        return commands;
    }

    public List<Command> getHighWatermarkMetadata(String schema, String entity, String watermarkColumn, List<Predicate> predicateList) throws HighWatermarkException {
        log.debug("Build query to get high watermark");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "max(" + Utils.getCoalesceColumnNames((String)watermarkColumn) + ")";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getCountMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        log.debug("Build query to get source record count");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "COUNT(1)";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        if (!StringUtils.isEmpty((CharSequence)sampleFilter)) {
            String col = sampleFilter + " 1 as col ";
            query = "SELECT COUNT(1) FROM (" + query.replace(" COUNT(1) ", col) + ")temp";
        }
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getDataMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException {
        log.debug("Build query to extract data");
        ArrayList<Command> commands = new ArrayList<Command>();
        int fetchSize = this.workUnitState.getPropAsInt("source.querybased.jdbc.resultset.fetch.size", 1000);
        log.info("Setting jdbc resultset fetch size as " + fetchSize);
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        if (!StringUtils.isEmpty((CharSequence)sampleFilter)) {
            String columnProjection = this.getOutputColumnProjection();
            String newColumnProjection = sampleFilter + " " + columnProjection;
            query = query.replace(columnProjection, newColumnProjection);
        }
        commands.add(JdbcExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(JdbcExtractor.getCommand(fetchSize, JdbcCommand.JdbcCommandType.FETCHSIZE));
        return commands;
    }

    public Map<String, String> getDataTypeMap() {
        ImmutableMap dataTypeMap = ImmutableMap.builder().put((Object)"smallint", (Object)"int").put((Object)"tinyint", (Object)"int").put((Object)"int", (Object)"int").put((Object)"bigint", (Object)"long").put((Object)"decimal", (Object)"double").put((Object)"numeric", (Object)"double").put((Object)"float", (Object)"float").put((Object)"real", (Object)"double").put((Object)"money", (Object)"double").put((Object)"smallmoney", (Object)"double").put((Object)"binary", (Object)"string").put((Object)"varbinary", (Object)"string").put((Object)"char", (Object)"string").put((Object)"varchar", (Object)"string").put((Object)"nchar", (Object)"string").put((Object)"nvarchar", (Object)"string").put((Object)"text", (Object)"string").put((Object)"ntext", (Object)"string").put((Object)"image", (Object)"string").put((Object)"hierarchyid", (Object)"string").put((Object)"uniqueidentifier", (Object)"string").put((Object)"date", (Object)"date").put((Object)"datetime", (Object)"timestamp").put((Object)"datetime2", (Object)"timestamp").put((Object)"datetimeoffset", (Object)"timestamp").put((Object)"smalldatetime", (Object)"timestamp").put((Object)"time", (Object)"time").put((Object)"bit", (Object)"boolean").build();
        return dataTypeMap;
    }

    public Iterator<JsonElement> getRecordSetFromSourceApi(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws IOException {
        return null;
    }

    @Override
    public String getConnectionUrl() {
        String host = this.workUnitState.getProp("source.conn.host");
        String port = this.workUnitState.getProp("source.conn.port");
        String parameters = this.workUnitState.getProp("source.querybased.sqlserver.connectionParameters");
        String database = this.workUnitState.getProp("source.querybased.schema");
        if (parameters == null && !StringUtils.isEmpty((CharSequence)database)) {
            parameters = "databaseName=" + database;
        }
        String url = "jdbc:sqlserver://" + host.trim() + ":" + port + (StringUtils.isEmpty((CharSequence)parameters) ? "" : ";" + parameters.trim());
        return url;
    }

    @Override
    public long extractSampleRecordCountFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return -1L;
        }
        long recordcount = -1L;
        String inputQuery = query.toLowerCase();
        int limitStartIndex = inputQuery.indexOf(" top ");
        int limitEndIndex = SqlServerExtractor.getLimitEndIndex(inputQuery, limitStartIndex);
        if (limitStartIndex > 0) {
            String limitValue = query.substring(limitStartIndex + 5, limitEndIndex);
            try {
                recordcount = Long.parseLong(limitValue);
            }
            catch (Exception e) {
                log.error("Ignoring incorrct limit value in input query:" + limitValue);
            }
        }
        return recordcount;
    }

    @Override
    public String removeSampleClauseFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        String outputQuery = query;
        String inputQuery = query.toLowerCase();
        int limitStartIndex = inputQuery.indexOf(" top ");
        int limitEndIndex = SqlServerExtractor.getLimitEndIndex(inputQuery, limitStartIndex);
        if (limitStartIndex > 0) {
            outputQuery = query.substring(0, limitStartIndex) + " " + query.substring(limitEndIndex);
        }
        return outputQuery;
    }

    private static int getLimitEndIndex(String inputQuery, int limitStartIndex) {
        int limitEndIndex = -1;
        if (limitStartIndex > 0) {
            limitEndIndex = limitStartIndex + 5;
            String remainingQuery = inputQuery.substring(limitEndIndex);
            boolean numFound = false;
            int pos = 0;
            while (pos < remainingQuery.length()) {
                char ch = remainingQuery.charAt(pos);
                if (ch == ' ' && !numFound) {
                    ++pos;
                    continue;
                }
                if (numFound && !Character.isDigit(ch)) break;
                numFound = true;
                ++pos;
            }
            limitEndIndex += pos;
        }
        return limitEndIndex;
    }

    @Override
    public String constructSampleClause() {
        long sampleRowCount = this.getSampleRecordCount();
        if (sampleRowCount >= 0L) {
            return " top " + sampleRowCount;
        }
        return "";
    }

    public String getWatermarkSourceFormat(WatermarkType watermarkType) {
        String columnFormat = null;
        switch (watermarkType) {
            case TIMESTAMP: {
                columnFormat = TIMESTAMP_FORMAT;
                break;
            }
            case DATE: {
                columnFormat = DATE_FORMAT;
                break;
            }
            default: {
                log.error("Watermark type " + watermarkType.toString() + " not recognized");
            }
        }
        return columnFormat;
    }

    public String getHourPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting hour predicate for Sqlserver");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)HOUR_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getDatePredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting date predicate for Sqlserver");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)DATE_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getTimestampPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting timestamp predicate for Sqlserver");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)TIMESTAMP_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }
}

