/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.jdbc.JdbcCommand;
import org.apache.gobblin.source.jdbc.JdbcExtractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlExtractor
extends JdbcExtractor {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlExtractor.class);
    private static final String CONNECTION_DATABASE = "source.conn.database";
    private static final String POSTGRES_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String POSTGRES_DATE_FORMAT = "yyyy-MM-dd";
    private static final String POSTGRES_HOUR_FORMAT = "HH";
    private static final long SAMPLERECORDCOUNT = -1L;

    public PostgresqlExtractor(WorkUnitState workUnitState) {
        super(workUnitState);
    }

    public String getHourPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting hour predicate for Postgres");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)POSTGRES_HOUR_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getDatePredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting date predicate for Postgres");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)POSTGRES_DATE_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public String getTimestampPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting timestamp predicate for Postgres");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)POSTGRES_TIMESTAMP_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedvalue + "'";
    }

    public List<Command> getSchemaMetadata(String schema, String entity) throws SchemaException {
        log.debug("Build query to get schema");
        ArrayList<Command> commands = new ArrayList<Command>();
        List<String> queryParams = Arrays.asList(entity, schema);
        String metadataSql = "select col.column_name, col.data_type, case when CHARACTER_OCTET_LENGTH is null then 0 else 0 end as length, case when NUMERIC_PRECISION is null then 0 else NUMERIC_PRECISION end as precesion, case when NUMERIC_SCALE is null then 0 else NUMERIC_SCALE end as scale, case when is_nullable='NO' then 'false' else 'true' end as nullable, '' as format, '' as comment from information_schema.COLUMNS col WHERE upper(col.table_name)=upper(?) AND upper(col.table_schema)=upper(?) order by col.ORDINAL_POSITION";
        commands.add(PostgresqlExtractor.getCommand(metadataSql, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(PostgresqlExtractor.getCommand(queryParams, JdbcCommand.JdbcCommandType.QUERYPARAMS));
        return commands;
    }

    public List<Command> getHighWatermarkMetadata(String schema, String entity, String watermarkColumn, List<Predicate> predicateList) throws HighWatermarkException {
        log.debug("Build query to get high watermark");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "max(" + Utils.getCoalesceColumnNames((String)watermarkColumn) + ")";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        commands.add(PostgresqlExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getCountMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        log.debug("Build query to get source record count");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "COUNT(1)";
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        query = query + sampleFilter;
        if (!StringUtils.isEmpty((CharSequence)sampleFilter)) {
            query = "SELECT COUNT(1) FROM (" + query.replace(" COUNT(1) ", " 1 ") + ")temp";
        }
        commands.add(PostgresqlExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getDataMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException {
        log.debug("Build query to extract data");
        ArrayList<Command> commands = new ArrayList<Command>();
        int fetchsize = this.workUnitState.getPropAsInt("source.querybased.jdbc.resultset.fetch.size", 1000);
        String watermarkFilter = this.concatPredicates(predicateList);
        String query = this.getExtractSql();
        if (StringUtils.isBlank((CharSequence)watermarkFilter)) {
            watermarkFilter = "1=1";
        }
        query = query.replace("'$WATERMARK'", watermarkFilter);
        String sampleFilter = this.constructSampleClause();
        query = query + sampleFilter;
        commands.add(PostgresqlExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(PostgresqlExtractor.getCommand(fetchsize, JdbcCommand.JdbcCommandType.FETCHSIZE));
        return commands;
    }

    @Override
    public String getConnectionUrl() {
        String host = this.workUnitState.getProp("source.conn.host");
        String port = this.workUnitState.getProp("source.conn.port");
        String database = this.workUnitState.getProp(CONNECTION_DATABASE);
        return "jdbc:postgresql://" + host.trim() + ":" + port + "/" + database.trim();
    }

    @Override
    protected boolean convertBitToBoolean() {
        return false;
    }

    public Map<String, String> getDataTypeMap() {
        ImmutableMap dataTypeMap = ImmutableMap.builder().put((Object)"tinyint", (Object)"int").put((Object)"smallint", (Object)"int").put((Object)"mediumint", (Object)"int").put((Object)"integer", (Object)"int").put((Object)"int", (Object)"int").put((Object)"bigint", (Object)"long").put((Object)"float", (Object)"float").put((Object)"double", (Object)"double").put((Object)"double precision", (Object)"double").put((Object)"decimal", (Object)"double").put((Object)"numeric", (Object)"double").put((Object)"date", (Object)"date").put((Object)"timestamp", (Object)"timestamp").put((Object)"timestamp without time zone", (Object)"timestamp").put((Object)"timestamp with time zone", (Object)"timestamp").put((Object)"datetime", (Object)"timestamp").put((Object)"time", (Object)"time").put((Object)"char", (Object)"string").put((Object)"varchar", (Object)"string").put((Object)"varbinary", (Object)"string").put((Object)"text", (Object)"string").put((Object)"tinytext", (Object)"string").put((Object)"mediumtext", (Object)"string").put((Object)"character varying", (Object)"string").put((Object)"longtext", (Object)"string").put((Object)"blob", (Object)"string").put((Object)"tinyblob", (Object)"string").put((Object)"mediumblob", (Object)"string").put((Object)"longblob", (Object)"string").put((Object)"enum", (Object)"string").build();
        return dataTypeMap;
    }

    public String getWatermarkSourceFormat(WatermarkType watermarkType) {
        String columnFormat = null;
        switch (watermarkType) {
            case TIMESTAMP: {
                columnFormat = POSTGRES_TIMESTAMP_FORMAT;
                break;
            }
            case DATE: {
                columnFormat = POSTGRES_DATE_FORMAT;
                break;
            }
            default: {
                log.error("Watermark type " + watermarkType.toString() + " not recognized");
            }
        }
        return columnFormat;
    }

    @Override
    public long extractSampleRecordCountFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return -1L;
        }
        long recordcount = -1L;
        String limit = null;
        String inputQuery = query.toLowerCase();
        int limitIndex = inputQuery.indexOf(" limit ");
        if (limitIndex > 0) {
            limit = query.substring(limitIndex + 7).trim();
        }
        if (StringUtils.isNotBlank(limit)) {
            try {
                recordcount = Long.parseLong(limit);
            }
            catch (Exception e) {
                log.error("Ignoring incorrct limit value in input query:" + limit);
            }
        }
        return recordcount;
    }

    @Override
    public String removeSampleClauseFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        String limitString = "";
        String inputQuery = query.toLowerCase();
        int limitIndex = inputQuery.indexOf(" limit");
        if (limitIndex > 0) {
            limitString = query.substring(limitIndex);
        }
        if (inputQuery.contains(" where ")) {
            String newQuery = query.replace(limitString, " AND 1=1");
            if (newQuery.toLowerCase().contains(" where and 1=1")) {
                return query.replace(limitString, " 1=1");
            }
            return newQuery;
        }
        return query.replace(limitString, " where 1=1");
    }

    @Override
    public String constructSampleClause() {
        long sampleRowCount = this.getSampleRecordCount();
        if (sampleRowCount >= 0L) {
            return " limit " + sampleRowCount;
        }
        return "";
    }

    @Override
    public String getLeftDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "`" : "";
    }

    @Override
    public String getRightDelimitedIdentifier() {
        return this.enableDelimitedIdentifier ? "`" : "";
    }

    public Iterator<JsonElement> getRecordSetFromSourceApi(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws IOException {
        return null;
    }
}

