/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.jdbc.JdbcCommand;
import org.apache.gobblin.source.jdbc.JdbcExtractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleExtractor
extends JdbcExtractor {
    private static final Logger log = LoggerFactory.getLogger(OracleExtractor.class);
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String HOUR_FORMAT = "HH";
    private static final long SAMPLERECORDCOUNT = -1L;
    private static final Pattern SAMPLE_CLAUSE_PATTERN = Pattern.compile(".*(rownum\\s*<\\s*=\\s*(\\d+)).*", 2);
    private static final String EMPTY_CONDITION = "1=1";
    private static final String METADATA_SCHEMA_PSTMT_FORMAT = "SELECT column_name, LOWER(data_type), NVL(data_length, 0) as length, NVL(data_precision, 0) as precesion, NVL(data_scale, 0) as scale, CASE NVL(NULLABLE, 'Y') WHEN 'Y' THEN 1 ELSE 0 END as nullable, ' ' as format, NVL(comments, ' ') as \"COMMENT\", column_id FROM all_tab_columns JOIN all_col_comments USING (owner, table_name, column_name) WHERE UPPER(owner) = (?) AND UPPER(table_name) = (?) ORDER BY column_id, column_name";
    private static Map<String, String> dataTypeMap = ImmutableMap.builder().put((Object)"char", (Object)"string").put((Object)"varchar2", (Object)"string").put((Object)"varchar", (Object)"string").put((Object)"nchar", (Object)"string").put((Object)"nvarchar2", (Object)"string").put((Object)"nclob", (Object)"string").put((Object)"clob", (Object)"string").put((Object)"long", (Object)"string").put((Object)"raw", (Object)"string").put((Object)"long raw", (Object)"string").put((Object)"rowid", (Object)"string").put((Object)"urowid", (Object)"string").put((Object)"xmltype", (Object)"string").put((Object)"smallint", (Object)"int").put((Object)"int", (Object)"int").put((Object)"integer", (Object)"int").put((Object)"bigint", (Object)"long").put((Object)"binary_float", (Object)"float").put((Object)"binary_double", (Object)"double").put((Object)"float", (Object)"double").put((Object)"number", (Object)"double").put((Object)"numeric", (Object)"double").put((Object)"dec", (Object)"double").put((Object)"decimal", (Object)"double").put((Object)"real", (Object)"double").put((Object)"double precision", (Object)"double").put((Object)"date", (Object)"date").put((Object)"interval year", (Object)"date").put((Object)"interval day", (Object)"timestamp").put((Object)"datetime", (Object)"timestamp").put((Object)"timestamp", (Object)"timestamp").put((Object)"timestamp(0)", (Object)"timestamp").put((Object)"timestamp(1)", (Object)"timestamp").put((Object)"timestamp(2)", (Object)"timestamp").put((Object)"timestamp(3)", (Object)"timestamp").put((Object)"timestamp(4)", (Object)"timestamp").put((Object)"timestamp(5)", (Object)"timestamp").put((Object)"timestamp(6)", (Object)"timestamp").put((Object)"timestamp(7)", (Object)"timestamp").put((Object)"timestamp(8)", (Object)"timestamp").put((Object)"timestamp(9)", (Object)"timestamp").put((Object)"timestamp with time zone", (Object)"timestamp").put((Object)"timezone with local timezone", (Object)"timestamp").build();

    public OracleExtractor(WorkUnitState workUnitState) {
        super(workUnitState);
    }

    public List<Command> getSchemaMetadata(String schema, String entity) throws SchemaException {
        log.debug("Build query to get schema");
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkNotNull((Object)entity);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(OracleExtractor.getCommand(METADATA_SCHEMA_PSTMT_FORMAT, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(OracleExtractor.getCommand(Arrays.asList(schema, entity), JdbcCommand.JdbcCommandType.QUERYPARAMS));
        return commands;
    }

    public List<Command> getHighWatermarkMetadata(String schema, String entity, String watermarkColumn, List<Predicate> predicateList) throws HighWatermarkException {
        log.debug("Build query to get high watermark");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "max(" + Utils.getCoalesceColumnNames((String)watermarkColumn) + ")";
        String watermarkFilter = (String)StringUtils.defaultIfBlank((CharSequence)this.concatPredicates(predicateList), (CharSequence)EMPTY_CONDITION);
        String query = this.getExtractSql();
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        commands.add(OracleExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getCountMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        log.debug("Build query to get source record count");
        ArrayList<Command> commands = new ArrayList<Command>();
        String columnProjection = "count(1)";
        String watermarkFilter = (String)StringUtils.defaultIfBlank((CharSequence)this.concatPredicates(predicateList), (CharSequence)EMPTY_CONDITION);
        String query = this.getExtractSql();
        query = query.replace(this.getOutputColumnProjection(), columnProjection).replace("'$WATERMARK'", watermarkFilter);
        query = this.addSampleQueryPart(query);
        query = this.castCountQuery(query);
        commands.add(OracleExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        return commands;
    }

    public List<Command> getDataMetadata(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException {
        log.debug("Build query to extract data");
        ArrayList<Command> commands = new ArrayList<Command>();
        int fetchSize = this.workUnitState.getPropAsInt("source.querybased.jdbc.resultset.fetch.size", 1000);
        log.info("Setting jdbc resultset fetch size as " + fetchSize);
        String watermarkFilter = (String)StringUtils.defaultIfBlank((CharSequence)this.concatPredicates(predicateList), (CharSequence)EMPTY_CONDITION);
        String query = this.getExtractSql();
        query = query.replace("'$WATERMARK'", watermarkFilter);
        query = this.addSampleQueryPart(query);
        commands.add(OracleExtractor.getCommand(query, JdbcCommand.JdbcCommandType.QUERY));
        commands.add(OracleExtractor.getCommand(fetchSize, JdbcCommand.JdbcCommandType.FETCHSIZE));
        return commands;
    }

    public Map<String, String> getDataTypeMap() {
        return dataTypeMap;
    }

    @Override
    public long extractSampleRecordCountFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return -1L;
        }
        long recordcount = -1L;
        Matcher matcher = SAMPLE_CLAUSE_PATTERN.matcher(query);
        if (matcher.matches()) {
            String limit = matcher.group(2);
            try {
                recordcount = Long.parseLong(limit);
            }
            catch (Exception e) {
                log.error("Ignoring incorrct limit value in input query:" + limit);
            }
        }
        return recordcount;
    }

    @Override
    public String removeSampleClauseFromQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        Matcher matcher = SAMPLE_CLAUSE_PATTERN.matcher(query);
        if (matcher.matches()) {
            query = query.replace(matcher.group(1), EMPTY_CONDITION);
        }
        return query;
    }

    @Override
    public String constructSampleClause() {
        long sampleRowCount = this.getSampleRecordCount();
        if (sampleRowCount >= 0L) {
            return " rownum <= " + sampleRowCount;
        }
        return "";
    }

    public Iterator<JsonElement> getRecordSetFromSourceApi(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws IOException {
        return null;
    }

    @Override
    public String getConnectionUrl() {
        String host = this.workUnitState.getProp("source.conn.host");
        String port = this.workUnitState.getProp("source.conn.port");
        String sid = this.workUnitState.getProp("source.conn.sid").trim();
        String url = "jdbc:oracle:thin:@" + host.trim() + (StringUtils.isEmpty((CharSequence)port) ? "" : ":" + port) + ":" + sid;
        return url;
    }

    public String getWatermarkSourceFormat(WatermarkType watermarkType) {
        String columnFormat = null;
        switch (watermarkType) {
            case TIMESTAMP: {
                columnFormat = "YYYY-MM-dd HH:mm:ss";
                break;
            }
            case DATE: {
                columnFormat = "YYYY-MM-dd HH:mm:ss";
                break;
            }
            case SIMPLE: {
                break;
            }
            default: {
                log.error("Watermark type " + watermarkType.toString() + " not recognized");
            }
        }
        return columnFormat;
    }

    public String getHourPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting hour predicate for Oracle");
        String formattedValue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)HOUR_FORMAT);
        return Utils.getCoalesceColumnNames((String)column) + " " + operator + " '" + formattedValue + "'";
    }

    public String getDatePredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting date predicate for Oracle");
        return this.getTimestampPredicateCondition(column, value, valueFormat, operator);
    }

    public String getTimestampPredicateCondition(String column, long value, String valueFormat, String operator) {
        log.debug("Getting timestamp predicate for Oracle");
        String formattedvalue = Utils.toDateTimeFormat((String)Long.toString(value), (String)valueFormat, (String)TIMESTAMP_FORMAT);
        return "cast(" + Utils.getCoalesceColumnNames((String)column) + " as timestamp(0)) " + operator + " to_timestamp('" + formattedvalue + "', 'YYYY-MM-DD HH24:MI:SS')";
    }

    private String addSampleQueryPart(String query) {
        String sampleClause = this.constructSampleClause();
        if (sampleClause.isEmpty()) {
            return query;
        }
        String where = "where";
        query = query.replaceFirst(where, String.format("where %s and ", sampleClause));
        return query;
    }

    private String castCountQuery(String query) {
        if (this.getSampleRecordCount() >= 0L) {
            return "select cast(count(1) as number) from (" + query.replace(" count(1) ", " * ") + ")temp";
        }
        return query.replace("count(1)", "cast(count(1) as number)");
    }
}

