/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.jdbc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.exception.ExtractPrepareException;
import org.apache.gobblin.source.extractor.extract.QueryBasedSource;
import org.apache.gobblin.source.jdbc.OracleExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSource
extends QueryBasedSource<JsonArray, JsonElement> {
    private static final Logger LOG = LoggerFactory.getLogger(OracleSource.class);

    public Extractor<JsonArray, JsonElement> getExtractor(WorkUnitState state) throws IOException {
        Extractor extractor = null;
        try {
            extractor = new OracleExtractor(state).build();
        }
        catch (ExtractPrepareException e) {
            LOG.error("Failed to prepare extractor: error - " + e.getMessage());
            throw new IOException(e);
        }
        return extractor;
    }
}

