/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;

public class JdbcEntryData
implements Iterable<JdbcEntryDatum> {
    private final Map<String, JdbcEntryDatum> jdbcEntryData;

    public JdbcEntryData(Iterable<JdbcEntryDatum> jdbcEntryDatumEntries) {
        Preconditions.checkNotNull(jdbcEntryDatumEntries);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (JdbcEntryDatum datum : jdbcEntryDatumEntries) {
            builder.put((Object)datum.getColumnName(), (Object)datum);
        }
        this.jdbcEntryData = builder.build();
    }

    public Object getVal(String columnName) {
        JdbcEntryDatum datum = this.jdbcEntryData.get(columnName);
        return datum == null ? null : datum.getVal();
    }

    @Override
    public Iterator<JdbcEntryDatum> iterator() {
        return this.jdbcEntryData.values().iterator();
    }

    public String toString() {
        return "JdbcEntryData(jdbcEntryData=" + this.jdbcEntryData + ")";
    }
}

