/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.initializer.AvroToJdbcEntryConverterInitializer;
import org.apache.gobblin.converter.initializer.ConverterInitializer;
import org.apache.gobblin.converter.jdbc.JdbcEntryData;
import org.apache.gobblin.converter.jdbc.JdbcEntryDatum;
import org.apache.gobblin.converter.jdbc.JdbcEntryMetaDatum;
import org.apache.gobblin.converter.jdbc.JdbcEntrySchema;
import org.apache.gobblin.converter.jdbc.JdbcType;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.writer.commands.JdbcWriterCommandsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroToJdbcEntryConverter
extends Converter<Schema, JdbcEntrySchema, GenericRecord, JdbcEntryData> {
    public static final String CONVERTER_AVRO_JDBC_DATE_FIELDS = "converter.avro.jdbc.date_fields";
    private static final String AVRO_NESTED_COLUMN_DELIMITER = ".";
    private static final String JDBC_FLATTENED_COLUMN_DELIMITER = "_";
    private static final String AVRO_NESTED_COLUMN_DELIMITER_REGEX_COMPATIBLE = "\\.";
    private static final Splitter AVRO_RECORD_LEVEL_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    private static final Logger LOG = LoggerFactory.getLogger(AvroToJdbcEntryConverter.class);
    private static final Map<Schema.Type, JdbcType> AVRO_TYPE_JDBC_TYPE_MAPPING = ImmutableMap.builder().put((Object)Schema.Type.BOOLEAN, (Object)JdbcType.BOOLEAN).put((Object)Schema.Type.INT, (Object)JdbcType.INTEGER).put((Object)Schema.Type.LONG, (Object)JdbcType.BIGINT).put((Object)Schema.Type.FLOAT, (Object)JdbcType.FLOAT).put((Object)Schema.Type.DOUBLE, (Object)JdbcType.DOUBLE).put((Object)Schema.Type.STRING, (Object)JdbcType.VARCHAR).put((Object)Schema.Type.ENUM, (Object)JdbcType.VARCHAR).build();
    private static final Set<Schema.Type> AVRO_SUPPORTED_TYPES = ImmutableSet.builder().addAll(AVRO_TYPE_JDBC_TYPE_MAPPING.keySet()).add((Object)Schema.Type.UNION).add((Object)Schema.Type.RECORD).build();
    private static final Set<JdbcType> JDBC_SUPPORTED_TYPES = ImmutableSet.builder().addAll(AVRO_TYPE_JDBC_TYPE_MAPPING.values()).add((Object)JdbcType.DATE).add((Object)JdbcType.TIME).add((Object)JdbcType.TIMESTAMP).build();
    private Optional<Map<String, String>> avroToJdbcColPairs = Optional.absent();
    private Map<String, String> jdbcToAvroColPairs = new HashMap<String, String>();

    public AvroToJdbcEntryConverter() {
    }

    @VisibleForTesting
    public AvroToJdbcEntryConverter(WorkUnitState workUnit) {
        this.init(workUnit);
    }

    public Converter<Schema, JdbcEntrySchema, GenericRecord, JdbcEntryData> init(WorkUnitState workUnit) {
        String avroToJdbcFieldsPairJsonStr = workUnit.getProp("converter.avro.jdbc.entry_fields_pairs");
        if (!StringUtils.isEmpty((CharSequence)avroToJdbcFieldsPairJsonStr) && !this.avroToJdbcColPairs.isPresent()) {
            ImmutableMap.Builder avroToJdbcBuilder = ImmutableMap.builder();
            ImmutableMap.Builder jdbcToAvroBuilder = ImmutableMap.builder();
            JsonObject json = new JsonParser().parse(avroToJdbcFieldsPairJsonStr).getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    throw new IllegalArgumentException("Json value should be a primitive String. converter.avro.jdbc.entry_fields_pairs : " + avroToJdbcFieldsPairJsonStr);
                }
                avroToJdbcBuilder.put(entry.getKey(), (Object)((JsonElement)entry.getValue()).getAsString());
                jdbcToAvroBuilder.put((Object)((JsonElement)entry.getValue()).getAsString(), entry.getKey());
            }
            this.avroToJdbcColPairs = Optional.of((Object)avroToJdbcBuilder.build());
        }
        return this;
    }

    public JdbcEntrySchema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        LOG.info("Converting schema " + inputSchema);
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)inputSchema.getType()), (String)"%s is expected for the first level element in Avro schema %s", (Object)Schema.Type.RECORD, (Object)inputSchema);
        Map<String, Schema.Type> avroColumnType = AvroToJdbcEntryConverter.flatten(inputSchema);
        String jsonStr = (String)Preconditions.checkNotNull((Object)workUnit.getProp(CONVERTER_AVRO_JDBC_DATE_FIELDS));
        Type typeOfMap = new TypeToken<Map<String, JdbcType>>(){}.getType();
        Map dateColumnMapping = (Map)new Gson().fromJson(jsonStr, typeOfMap);
        LOG.info("Date column mapping: " + dateColumnMapping);
        ArrayList jdbcEntryMetaData = Lists.newArrayList();
        for (Map.Entry<String, Schema.Type> avroEntry : avroColumnType.entrySet()) {
            String colName = this.tryConvertAvroColNameToJdbcColName(avroEntry.getKey());
            JdbcType JdbcType2 = (JdbcType)((Object)dateColumnMapping.get(colName));
            if (JdbcType2 == null) {
                JdbcType2 = AVRO_TYPE_JDBC_TYPE_MAPPING.get(avroEntry.getValue());
            }
            Preconditions.checkNotNull((Object)((Object)JdbcType2), (Object)("Failed to convert " + avroEntry + " AVRO_TYPE_JDBC_TYPE_MAPPING: " + AVRO_TYPE_JDBC_TYPE_MAPPING + " , dateColumnMapping: " + dateColumnMapping));
            jdbcEntryMetaData.add(new JdbcEntryMetaDatum(colName, JdbcType2));
        }
        JdbcEntrySchema converted = new JdbcEntrySchema(jdbcEntryMetaData);
        LOG.info("Converted schema into " + converted);
        return converted;
    }

    private String tryConvertAvroColNameToJdbcColName(String avroColName) {
        if (!this.avroToJdbcColPairs.isPresent()) {
            String converted = avroColName.replaceAll(AVRO_NESTED_COLUMN_DELIMITER_REGEX_COMPATIBLE, JDBC_FLATTENED_COLUMN_DELIMITER);
            this.jdbcToAvroColPairs.put(converted, avroColName);
            return converted;
        }
        String converted = (String)((Map)this.avroToJdbcColPairs.get()).get(avroColName);
        converted = converted != null ? converted : avroColName;
        this.jdbcToAvroColPairs.put(converted, avroColName);
        return converted;
    }

    private String convertJdbcColNameToAvroColName(String colName) {
        return (String)Preconditions.checkNotNull((Object)this.jdbcToAvroColPairs.get(colName));
    }

    private static Map<String, Schema.Type> flatten(Schema schema) throws SchemaConversionException {
        LinkedHashMap<String, Schema.Type> flattened = new LinkedHashMap<String, Schema.Type>();
        Schema recordSchema = AvroToJdbcEntryConverter.determineType(schema);
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)recordSchema.getType()), (String)"%s is expected. Schema: %s", (Object)Schema.Type.RECORD, (Object)recordSchema);
        for (Schema.Field f : recordSchema.getFields()) {
            AvroToJdbcEntryConverter.produceFlattenedHelper(f, flattened);
        }
        return flattened;
    }

    private static void produceFlattenedHelper(Schema.Field field, Map<String, Schema.Type> flattened) throws SchemaConversionException {
        Schema actualSchema = AvroToJdbcEntryConverter.determineType(field.schema());
        if (Schema.Type.RECORD.equals((Object)actualSchema.getType())) {
            Map<String, Schema.Type> map = AvroToJdbcEntryConverter.flatten(actualSchema);
            for (Map.Entry<String, Schema.Type> entry : map.entrySet()) {
                String key = String.format("%s.%s", field.name(), entry.getKey());
                Schema.Type existing = flattened.put(key, entry.getValue());
                Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)("Duplicate name detected in Avro schema. Field: " + key));
            }
            return;
        }
        Schema.Type existing = flattened.put(field.name(), actualSchema.getType());
        if (existing != null) {
            throw new SchemaConversionException("Duplicate name detected in Avro schema. " + field.name());
        }
    }

    private static Schema determineType(Schema schema) throws SchemaConversionException {
        if (!AVRO_SUPPORTED_TYPES.contains(schema.getType())) {
            throw new SchemaConversionException(schema.getType() + " is not supported");
        }
        if (!Schema.Type.UNION.equals((Object)schema.getType())) {
            return schema;
        }
        List schemas = schema.getTypes();
        if (schemas.size() > 2) {
            throw new SchemaConversionException("More than two types are not supported " + schemas);
        }
        for (Schema s : schemas) {
            if (Schema.Type.NULL.equals((Object)s.getType())) continue;
            return s;
        }
        throw new SchemaConversionException("Cannot determine type of " + schema);
    }

    public Iterable<JdbcEntryData> convertRecord(JdbcEntrySchema outputSchema, GenericRecord record, WorkUnitState workUnit) throws DataConversionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting " + record);
        }
        ArrayList jdbcEntryData = Lists.newArrayList();
        block7: for (JdbcEntryMetaDatum entry : outputSchema) {
            String jdbcColName = entry.getColumnName();
            JdbcType jdbcType = entry.getJdbcType();
            String avroColName = this.convertJdbcColNameToAvroColName(jdbcColName);
            Object val = this.avroRecordValueGet(record, AVRO_RECORD_LEVEL_SPLITTER.split((CharSequence)avroColName).iterator());
            if (val == null) {
                jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, null));
                continue;
            }
            if (!JDBC_SUPPORTED_TYPES.contains((Object)jdbcType)) {
                throw new DataConversionException("Unsupported JDBC type detected " + (Object)((Object)jdbcType));
            }
            switch (jdbcType) {
                case VARCHAR: {
                    jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, val.toString()));
                    continue block7;
                }
                case INTEGER: 
                case BOOLEAN: 
                case BIGINT: 
                case FLOAT: 
                case DOUBLE: {
                    jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, val));
                    continue block7;
                }
                case DATE: {
                    jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, new Date((Long)val)));
                    continue block7;
                }
                case TIME: {
                    jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, new Time((Long)val)));
                    continue block7;
                }
                case TIMESTAMP: {
                    jdbcEntryData.add(new JdbcEntryDatum(jdbcColName, new Timestamp((Long)val)));
                    continue block7;
                }
            }
            throw new DataConversionException((Object)((Object)jdbcType) + " is not supported");
        }
        JdbcEntryData converted = new JdbcEntryData(jdbcEntryData);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted data into " + converted);
        }
        return new SingleRecordIterable((Object)converted);
    }

    private Object avroRecordValueGet(GenericRecord record, Iterator<String> recordNameIterator) {
        String name = recordNameIterator.next();
        Object val = record.get(name);
        if (val == null) {
            return null;
        }
        if (!recordNameIterator.hasNext()) {
            return val;
        }
        return this.avroRecordValueGet((GenericRecord)val, recordNameIterator);
    }

    public ConverterInitializer getInitializer(State state, WorkUnitStream workUnits, int branches, int branchId) {
        JdbcWriterCommandsFactory factory = new JdbcWriterCommandsFactory();
        if (workUnits.isSafeToMaterialize()) {
            return new AvroToJdbcEntryConverterInitializer(state, workUnits.getMaterializedWorkUnitCollection(), factory, branches, branchId);
        }
        throw new RuntimeException(AvroToJdbcEntryConverter.class.getName() + " does not support work unit streams.");
    }
}

