/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.typedconfig;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.gobblin.typedconfig.Alias;
import org.apache.gobblin.typedconfig.ConstraintUtil;
import org.apache.gobblin.typedconfig.Default;
import org.apache.gobblin.typedconfig.Key;

public class TypedConfig {
    public TypedConfig(Properties prop) {
        if (prop != null) {
            this.fulfillFields(this.getClass(), prop);
        }
    }

    private void fulfillFields(Class<? extends TypedConfig> clazz, Properties prop) {
        if (!clazz.equals(TypedConfig.class)) {
            this.fulfillFields(clazz.getSuperclass(), prop);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotations().length == 0) continue;
            Object defaultValue = this.pickupDefaultValue(field);
            Object configValue = this.pickupValueByKey(field, prop);
            if (configValue == null) {
                configValue = this.pickupValueByAlias(field, prop);
            }
            if (configValue == null) {
                configValue = defaultValue;
            }
            if (configValue == null) continue;
            configValue = ConstraintUtil.constraint(field, configValue);
            field.set(this, this.convert(configValue, field.getType()));
        }
    }

    private Object pickupDefaultValue(Field field) {
        Default defaultAnn = field.getAnnotation(Default.class);
        if (defaultAnn == null) {
            return null;
        }
        return defaultAnn.value();
    }

    private Object pickupValueByAlias(Field field, Properties prop) {
        Alias alias = field.getAnnotation(Alias.class);
        if (alias == null) {
            return null;
        }
        return prop.get(alias.value());
    }

    private Object pickupValueByKey(Field field, Properties prop) {
        Key key = field.getAnnotation(Key.class);
        if (key == null) {
            return null;
        }
        return prop.get(key.value());
    }

    private Object convert(Object value, Class targetClazz) {
        if (value == null) {
            return null;
        }
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean(new ConvertUtilsBean(){

            public Object convert(Object value, Class clazz) {
                if (clazz.isEnum()) {
                    return Enum.valueOf(clazz, (String)value);
                }
                if (clazz == Date.class) {
                    String dateStr = ((String)value).replaceAll("-| |:", "");
                    dateStr = String.format("%-14s", dateStr).replaceAll(" ", "0");
                    Date date = new SimpleDateFormat("yyyyMMddHHmmss").parse(dateStr);
                    return date;
                }
                return super.convert(value, clazz);
            }
        });
        return beanUtilsBean.getConvertUtils().convert(value, targetClazz);
    }

    public Properties toProp() {
        Properties prop = new Properties();
        for (Field field : this.getClass().getDeclaredFields()) {
            Object configValue;
            Key keyAnn = field.getAnnotation(Key.class);
            if (keyAnn == null || (configValue = field.get(this)) == null) continue;
            prop.put(keyAnn.value(), configValue.toString());
        }
        return prop;
    }
}

