/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.password;

import com.google.common.base.Preconditions;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import org.apache.gobblin.password.PasswordManager;

public class EncryptedPasswordAuthenticator
extends Authenticator {
    public static final String AUTHENTICATOR_USERNAME = "authenticator.username";
    public static final String AUTHENTICATOR_PASSWORD = "authenticator.password";
    private final String username;
    private final String password;

    public EncryptedPasswordAuthenticator(Properties props) {
        this.username = props.getProperty(AUTHENTICATOR_USERNAME);
        this.password = PasswordManager.getInstance(props).readPassword(props.getProperty(AUTHENTICATOR_PASSWORD));
        Preconditions.checkNotNull((Object)this.username, (Object)"authenticator.username must be set for EncryptedPasswordAuthenticator");
        Preconditions.checkNotNull((Object)this.password, (Object)"authenticator.password must be set for EncryptedPasswordAuthenticator");
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.username, this.password.toCharArray());
    }
}

