/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.commit;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.configuration.State;

@Alpha
public abstract class CommitStepBase
implements CommitStep {
    protected final State props;

    protected CommitStepBase(Builder<? extends Builder<?>> builder) {
        Preconditions.checkNotNull((Object)builder.props);
        this.props = builder.props;
    }

    public static abstract class Builder<T extends Builder<?>> {
        private final Optional<CommitSequence.Builder> commitSequenceBuilder;
        protected State props;

        protected Builder() {
            this.commitSequenceBuilder = Optional.absent();
        }

        protected Builder(CommitSequence.Builder commitSequenceBuilder) {
            Preconditions.checkNotNull((Object)commitSequenceBuilder);
            this.commitSequenceBuilder = Optional.of((Object)commitSequenceBuilder);
        }

        public T withProps(State props) {
            this.props = new State(props.getProperties());
            return (T)this;
        }

        public CommitSequence.Builder endStep() throws IOException {
            Preconditions.checkState((boolean)this.commitSequenceBuilder.isPresent());
            ((CommitSequence.Builder)this.commitSequenceBuilder.get()).addStep(this.build());
            return (CommitSequence.Builder)this.commitSequenceBuilder.get();
        }

        public abstract CommitStep build() throws IOException;
    }
}

