/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pluto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.pluto.PortalContainerServices;
import org.apache.geronimo.pluto.impl.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.apache.pluto.driver.services.portal.admin.RenderConfigAdminService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConsoleExtensionGBean
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(AdminConsoleExtensionGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private final String pageTitle;
    private final String portletContext;
    private final ArrayList<String> portletList;
    private final String icon;
    private final PortalContainerServices portletContainerServices;

    public AdminConsoleExtensionGBean(String pageTitle, String portletContext, ArrayList<String> portletList, PortalContainerServices portalContainerServices) {
        this(pageTitle, portletContext, portletList, null, portalContainerServices);
    }

    public AdminConsoleExtensionGBean(String pageTitle, String portletContext, ArrayList<String> portletList, String icon, PortalContainerServices portalContainerServices) {
        this.pageTitle = pageTitle;
        this.portletContext = portletContext;
        this.portletList = portletList;
        this.icon = icon;
        this.portletContainerServices = portalContainerServices;
    }

    private void addPage(PageConfig pageConfig) {
        RenderConfigAdminService renderConfig = this.portletContainerServices.getAdminConfiguration().getRenderConfigAdminService();
        renderConfig.addPage((org.apache.pluto.driver.services.portal.PageConfig)pageConfig);
    }

    private void addPortlets() {
        if (this.pageExists()) {
            PageConfig pageConfig = this.getPageConfigFromPluto();
            int portletCount = this.portletList.size();
            for (int i = 0; i < portletCount; ++i) {
                pageConfig.addPortlet(this.portletContext, this.portletList.get(i));
            }
        } else {
            log.warn("Cannot add portlets to non-existent page " + this.pageTitle);
        }
    }

    private void removePage() {
        PageConfig pageConfig = this.createPageConfig();
        RenderConfigAdminService renderConfig = this.portletContainerServices.getAdminConfiguration().getRenderConfigAdminService();
        renderConfig.removePage((org.apache.pluto.driver.services.portal.PageConfig)pageConfig);
    }

    private void removePortlets() {
        if (this.pageExists()) {
            PageConfig pageConfig = this.getPageConfigFromPluto();
            int portletCount = this.portletList.size();
            Collection list = pageConfig.getPortletIds();
            block0: for (int i = 0; i < portletCount; ++i) {
                String portletName = this.portletList.get(i);
                for (String pid : list) {
                    String pletContext = PortletWindowConfig.parseContextPath((String)pid);
                    String pletName = PortletWindowConfig.parsePortletName((String)pid);
                    if (!this.portletContext.equals(pletContext) || !portletName.equals(pletName)) continue;
                    pageConfig.removePortlet(pid);
                    continue block0;
                }
            }
        } else {
            log.warn("can't remove portlets from non-existent page " + this.pageTitle);
        }
    }

    private PageConfig createPageConfig() {
        PageConfig pageConfig = new PageConfig();
        pageConfig.setName(this.pageTitle);
        pageConfig.setUri("/WEB-INF/themes/default-theme.jsp");
        pageConfig.setIcon(this.icon);
        return pageConfig;
    }

    private PageConfig getPageConfigFromPluto() {
        RenderConfigService service = this.portletContainerServices.getRenderConfigService();
        return (PageConfig)service.getPage(this.pageTitle);
    }

    private boolean pageExists() {
        if (this.pageTitle == null) {
            return false;
        }
        RenderConfigService service = this.portletContainerServices.getRenderConfigService();
        List pageConfigs = service.getPages();
        for (PageConfig pageConfig : pageConfigs) {
            if (!this.pageTitle.equals(pageConfig.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean pageIsEmpty() {
        if (this.pageExists()) {
            PageConfig pageConfig = this.getPageConfigFromPluto();
            return pageConfig.getPortletIds().size() == 0;
        }
        log.debug("no pageConfig found for " + this.pageTitle);
        return true;
    }

    public synchronized void doStart() throws Exception {
        this.portletContainerServices.waitForInitialization(60000);
        if (this.portletContainerServices.getAdminConfiguration() == null) {
            throw new RuntimeException("No portal driver has been registered with the portal container services");
        }
        if (!this.pageExists()) {
            PageConfig newPageConfig = this.createPageConfig();
            this.addPage(newPageConfig);
        }
        this.addPortlets();
        log.debug("Started AdminConsoleExtensionGBean for " + this.pageTitle);
    }

    public synchronized void doStop() throws Exception {
        try {
            this.removePortlets();
            if (this.pageIsEmpty()) {
                this.removePage();
            }
        }
        catch (NullPointerException e) {
            log.debug("could not remove portlets for " + this.pageTitle, (Throwable)e);
        }
        log.debug("Stopped AdminConsoleExtensionGBean for " + this.pageTitle);
    }

    public synchronized void doFail() {
        log.warn("AdminConsoleExtensionGBean for " + this.pageTitle + " failed.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("AdminConsoleExtensionGBean", AdminConsoleExtensionGBean.class);
        infoFactory.addAttribute("pageTitle", String.class, true, true);
        infoFactory.addAttribute("portletContext", String.class, true, true);
        infoFactory.addAttribute("portletList", ArrayList.class, true, true);
        infoFactory.addAttribute("icon", String.class, true, true);
        infoFactory.addReference("PortalContainerServices", PortalContainerServices.class, "GBean");
        infoFactory.setConstructor(new String[]{"pageTitle", "portletContext", "portletList", "icon", "PortalContainerServices"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

