/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pluto.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.geronimo.pluto.impl.PageConfig;
import org.apache.pluto.driver.services.impl.resource.ResourceConfig;
import org.apache.pluto.driver.services.portal.RenderConfig;
import org.xml.sax.SAXException;

public class ResourceConfigReader {
    public static final String CONFIG_FILE = "/WEB-INF/pluto-portal-driver-config.xml";
    private static ResourceConfigReader factory;
    private Digester digester = new Digester();

    public static ResourceConfigReader getFactory() {
        if (factory == null) {
            factory = new ResourceConfigReader();
        }
        return factory;
    }

    private ResourceConfigReader() {
        this.digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.init();
    }

    public ResourceConfig parse(InputStream in) throws IOException, SAXException {
        return (ResourceConfig)this.digester.parse(in);
    }

    private void init() {
        this.digester.addObjectCreate("pluto-portal-driver", ResourceConfig.class);
        this.digester.addBeanPropertySetter("pluto-portal-driver/portal-name", "portalName");
        this.digester.addBeanPropertySetter("pluto-portal-driver/portal-version", "portalVersion");
        this.digester.addBeanPropertySetter("pluto-portal-driver/container-name", "containerName");
        this.digester.addCallMethod("pluto-portal-driver/supports/portlet-mode", "addSupportedPortletMode", 0);
        this.digester.addCallMethod("pluto-portal-driver/supports/window-state", "addSupportedWindowState", 0);
        this.digester.addObjectCreate("pluto-portal-driver/render-config", RenderConfig.class);
        this.digester.addSetProperties("pluto-portal-driver/render-config", "default", "defaultPageId");
        this.digester.addObjectCreate("pluto-portal-driver/render-config/page", PageConfig.class);
        this.digester.addSetProperties("pluto-portal-driver/render-config/page");
        this.digester.addCallMethod("pluto-portal-driver/render-config/page/portlet", "addPortlet", 2);
        this.digester.addCallParam("pluto-portal-driver/render-config/page/portlet", 0, "context");
        this.digester.addCallParam("pluto-portal-driver/render-config/page/portlet", 1, "name");
        this.digester.addSetNext("pluto-portal-driver/render-config/page", "addPage");
        this.digester.addSetNext("pluto-portal-driver/render-config", "setRenderConfig");
    }
}

