/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.reporting;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.apache.geronimo.mavenplugins.geronimo.GeronimoMojoSupport;
import org.apache.geronimo.mavenplugins.geronimo.reporting.Reportable;
import org.apache.geronimo.mavenplugins.geronimo.reporting.Reporter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class ReportingMojoSupport
extends GeronimoMojoSupport {
    protected boolean logOutput = false;
    protected File logOutputDirectory;
    protected File logFile = null;
    protected Reporter[] reporters = null;
    protected boolean stopOnFailure;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (this.log.isDebugEnabled()) {
            if (this.reporters != null) {
                this.log.debug((CharSequence)("Reporters: " + Arrays.asList(this.reporters)));
            } else {
                this.log.debug((CharSequence)"No reporters configured");
            }
        }
        this.reportBegin();
        try {
            this.doExecute();
        }
        catch (Exception e) {
            this.reportError(e);
            if (this.stopOnFailure) {
                if (e instanceof MojoExecutionException) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                if (e instanceof MojoFailureException) {
                    MojoFailureException x = new MojoFailureException(e.getMessage());
                    x.initCause((Throwable)e);
                    throw x;
                }
                throw new MojoExecutionException(e.getMessage(), e);
            }
            this.log.warn((CharSequence)"Ignoring failure !");
        }
        finally {
            this.reportEnd();
        }
    }

    protected File getLogFile() {
        if (this.logFile == null) {
            return new File(this.logOutputDirectory, this.getFullClassName() + ".log");
        }
        try {
            return this.logFile.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getFullClassName();

    private void reportBegin() {
        if (this.reporters == null) {
            return;
        }
        Reportable source = new Reportable(){
            final Date start = new Date();

            public Date getStartTime() {
                return this.start;
            }

            public String getName() {
                return ReportingMojoSupport.this.getFullClassName();
            }

            public File getLogFile() {
                return ReportingMojoSupport.this.getLogFile();
            }
        };
        for (int i = 0; i < this.reporters.length; ++i) {
            this.reporters[i].reportBegin(source);
        }
    }

    private void reportError(Throwable cause) {
        assert (cause != null);
        if (this.reporters == null) {
            return;
        }
        for (int i = 0; i < this.reporters.length; ++i) {
            this.reporters[i].reportError(cause);
        }
    }

    private void reportEnd() {
        if (this.reporters == null) {
            return;
        }
        for (int i = 0; i < this.reporters.length; ++i) {
            this.reporters[i].reportEnd();
        }
    }
}

