/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLVisitor {
    private static final Log log = LogFactory.getLog(WSDLVisitor.class);
    protected final Definition definition;

    public WSDLVisitor(Definition definition) {
        this.definition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkTree() {
        this.begin();
        try {
            this.visit(this.definition);
            for (Map.Entry entry : this.definition.getImports().entrySet()) {
                String namespaceURI = (String)entry.getKey();
                List importsForNamespace = (List)entry.getValue();
                for (Import anImport : importsForNamespace) {
                    this.visit(anImport);
                }
            }
            this.visit(this.definition.getTypes());
            Collection messages = this.definition.getMessages().values();
            for (Message message : messages) {
                this.visit(message);
                Collection parts = message.getParts().values();
                for (Part part : parts) {
                    this.visit(part);
                }
            }
            Collection services = this.definition.getServices().values();
            for (Service service : services) {
                this.visit(service);
                Collection ports = service.getPorts().values();
                for (Port port : ports) {
                    this.visit(port);
                    Binding binding = port.getBinding();
                    this.visit(binding);
                    List bindingOperations = binding.getBindingOperations();
                    for (int i = 0; i < bindingOperations.size(); ++i) {
                        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(i);
                        this.visit(bindingOperation);
                        this.visit(bindingOperation.getBindingInput());
                        this.visit(bindingOperation.getBindingOutput());
                        Collection bindingFaults = bindingOperation.getBindingFaults().values();
                        for (BindingFault bindingFault : bindingFaults) {
                            this.visit(bindingFault);
                        }
                    }
                    PortType portType = binding.getPortType();
                    this.visit(portType);
                    List operations = portType.getOperations();
                    for (int i = 0; i < operations.size(); ++i) {
                        Operation operation = (Operation)operations.get(i);
                        this.visit(operation);
                        Input input = operation.getInput();
                        this.visit(input);
                        Output output = operation.getOutput();
                        this.visit(output);
                        Collection faults = operation.getFaults().values();
                        for (Fault fault : faults) {
                            this.visit(fault);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected void visit(Fault fault) {
    }

    protected void visit(Definition definition) {
    }

    protected void visit(Import wsdlImport) {
    }

    protected void visit(Types types) {
    }

    protected void visit(BindingFault bindingFault) {
    }

    protected void visit(BindingOutput bindingOutput) {
    }

    protected void visit(BindingInput bindingInput) {
    }

    protected void visit(Output output) {
    }

    protected void visit(Part part) {
    }

    protected void visit(Message message) {
    }

    protected void visit(Input input) {
    }

    protected void visit(Operation operation) {
    }

    protected void visit(PortType portType) {
    }

    protected void visit(BindingOperation bindingOperation) {
    }

    protected void visit(Binding binding) {
    }

    protected void visit(Port port) {
    }

    protected void visit(Service service) {
    }

    protected SOAPBody getSOAPBody(List extensibilityElements) {
        SOAPBody body = null;
        for (int j = 0; j < extensibilityElements.size(); ++j) {
            Object element = extensibilityElements.get(j);
            if (!(element instanceof SOAPBody)) continue;
            body = (SOAPBody)element;
            break;
        }
        return body;
    }

    protected SOAPBinding getSOAPBinding(Binding binding) {
        SOAPBinding soapBinding = null;
        List extensibilityElements = binding.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Object element = extensibilityElements.get(i);
            if (!(element instanceof SOAPBinding)) continue;
            soapBinding = (SOAPBinding)element;
        }
        return soapBinding;
    }
}

