/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.geronimo.webservices.PortComponent;

public class WebServiceDescription {
    private String webServiceDescriptionName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private ArrayList portComponentList = new ArrayList();
    private HashMap portComponentMap = new HashMap();

    public String getWebServiceDescriptionName() {
        return this.webServiceDescriptionName;
    }

    public void setWebServiceDescriptionName(String webServiceDescriptionName) {
        this.webServiceDescriptionName = webServiceDescriptionName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public void addPortComponent(PortComponent portComponent) throws IndexOutOfBoundsException {
        this.portComponentList.add(portComponent);
        this.portComponentMap.put(portComponent.getPortComponentName(), portComponent);
    }

    public void addPortComponent(int index, PortComponent portComponent) throws IndexOutOfBoundsException {
        this.portComponentList.add(index, portComponent);
        this.portComponentMap.put(portComponent.getPortComponentName(), portComponent);
    }

    public boolean removePortComponent(PortComponent portComponent) {
        this.portComponentMap.remove(portComponent.getPortComponentName());
        return this.portComponentList.remove(portComponent);
    }

    public PortComponent getPortComponent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.portComponentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (PortComponent)this.portComponentList.get(index);
    }

    public PortComponent[] getPortComponent() {
        int size = this.portComponentList.size();
        PortComponent[] mArray = new PortComponent[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (PortComponent)this.portComponentList.get(index);
        }
        return mArray;
    }

    public PortComponent getPortComponent(String portComponentName) {
        return (PortComponent)this.portComponentMap.get(portComponentName);
    }

    public void setPortComponent(int index, PortComponent portComponent) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.portComponentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        PortComponent removed = this.portComponentList.set(index, portComponent);
        this.portComponentMap.remove(removed.getPortComponentName());
        this.portComponentMap.put(portComponent.getPortComponentName(), portComponent);
    }

    public void setPortComponent(PortComponent[] portComponentArray) {
        this.portComponentList.clear();
        for (int i = 0; i < portComponentArray.length; ++i) {
            PortComponent portComponent = portComponentArray[i];
            this.portComponentList.add(portComponent);
            this.portComponentMap.put(portComponent.getPortComponentName(), portComponent);
        }
    }

    public void clearPortComponent() {
        this.portComponentList.clear();
        this.portComponentMap.clear();
    }
}

