/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import javax.xml.namespace.QName;

public final class SchemaTypeKey {
    public static final String QNAME_SCOPE_COMPLEX_TYPE = "complexType";
    public static final String QNAME_SCOPE_SIMPLE_TYPE = "simpleType";
    public static final String QNAME_SCOPE_ELEMENT = "element";
    private final QName qName;
    private final String qNameScope;
    private final boolean isElement;
    private final boolean isSimpleType;
    private final boolean isAnonymous;
    private final QName elementQName;

    public SchemaTypeKey(QName qName, boolean element, boolean isSimpleType, boolean anonymous, QName elementQName) {
        assert (qName != null);
        this.qName = qName;
        this.isElement = element;
        this.isSimpleType = isSimpleType;
        this.isAnonymous = anonymous;
        this.qNameScope = this.isElement ? QNAME_SCOPE_ELEMENT : (isSimpleType ? QNAME_SCOPE_SIMPLE_TYPE : QNAME_SCOPE_COMPLEX_TYPE);
        this.elementQName = elementQName;
    }

    public QName getqName() {
        return this.qName;
    }

    public boolean isElement() {
        return this.isElement;
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public String getqNameScope() {
        return this.qNameScope;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public int hashCode() {
        return this.qName.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SchemaTypeKey)) {
            return false;
        }
        SchemaTypeKey key = (SchemaTypeKey)other;
        return this.isElement == key.isElement && this.isSimpleType == key.isSimpleType && this.isAnonymous == key.isAnonymous && this.qName.equals(key.qName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\nSchemaTypeKey: scope: ").append(this.qNameScope);
        buf.append(" isElement: ").append(this.isElement);
        buf.append(" isAnonymous: ").append(this.isAnonymous);
        buf.append(" isSimpleType: ").append(this.isSimpleType);
        buf.append("\n QName: ").append(this.qName).append("\n");
        return buf.toString();
    }
}

