/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.webservices.builder.PortInfo;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;
import org.apache.geronimo.xbeans.j2ee.ExceptionMappingType;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingDocument;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.PackageMappingType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentHandlerType;
import org.apache.geronimo.xbeans.j2ee.PortComponentType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointInterfaceMappingType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointMethodMappingType;
import org.apache.geronimo.xbeans.j2ee.ServiceImplBeanType;
import org.apache.geronimo.xbeans.j2ee.WebserviceDescriptionType;
import org.apache.geronimo.xbeans.j2ee.WebservicesDocument;
import org.apache.geronimo.xbeans.j2ee.WebservicesType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class WSDescriptorParser {
    private static final Map rpcHolderClasses = new HashMap();

    public static JavaWsdlMappingType readJaxrpcMapping(JarFile moduleFile, URI jaxrpcMappingURI) throws DeploymentException {
        String jaxrpcMappingPath = jaxrpcMappingURI.toString();
        return WSDescriptorParser.readJaxrpcMapping(moduleFile, jaxrpcMappingPath);
    }

    public static JavaWsdlMappingType readJaxrpcMapping(JarFile moduleFile, String jaxrpcMappingPath) throws DeploymentException {
        InputStream jaxrpcInputStream = null;
        try {
            ZipEntry zipEntry = moduleFile.getEntry(jaxrpcMappingPath);
            if (zipEntry == null) {
                throw new DeploymentException("The JAX-RPC mapping file " + jaxrpcMappingPath + " specified in webservices.xml for the ejb module could not be found.");
            }
            jaxrpcInputStream = moduleFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not open stream to jaxrpc mapping document", (Throwable)e);
        }
        JavaWsdlMappingDocument mappingDocument = null;
        try {
            mappingDocument = JavaWsdlMappingDocument.Factory.parse((InputStream)jaxrpcInputStream);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse jaxrpc mapping document", (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read jaxrpc mapping document", (Throwable)e);
        }
        JavaWsdlMappingType mapping = mappingDocument.getJavaWsdlMapping();
        return mapping;
    }

    public static Map getExceptionMap(JavaWsdlMappingType mapping) {
        HashMap<QName, ExceptionMappingType> exceptionMap = new HashMap<QName, ExceptionMappingType>();
        if (mapping != null) {
            ExceptionMappingType[] exceptionMappings = mapping.getExceptionMappingArray();
            for (int i = 0; i < exceptionMappings.length; ++i) {
                ExceptionMappingType exceptionMapping = exceptionMappings[i];
                QName exceptionMessageQName = exceptionMapping.getWsdlMessage().getQNameValue();
                exceptionMap.put(exceptionMessageQName, exceptionMapping);
            }
        }
        return exceptionMap;
    }

    public static String getPackageFromNamespace(String namespace, JavaWsdlMappingType mapping) throws DeploymentException {
        PackageMappingType[] packageMappings = mapping.getPackageMappingArray();
        for (int i = 0; i < packageMappings.length; ++i) {
            PackageMappingType packageMapping = packageMappings[i];
            if (!namespace.equals(packageMapping.getNamespaceURI().getStringValue().trim())) continue;
            return packageMapping.getPackageType().getStringValue().trim();
        }
        throw new DeploymentException("Namespace " + namespace + " was not mapped in jaxrpc mapping file");
    }

    public static Class getHolderType(String paramJavaTypeName, boolean isInOnly, QName typeQName, boolean isComplexType, JavaWsdlMappingType mapping, ClassLoader classLoader) throws DeploymentException {
        Class holder;
        String holderName;
        Class paramJavaType = null;
        if (isInOnly) {
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            return paramJavaType;
        }
        if (isComplexType) {
            String namespace = typeQName.getNamespaceURI();
            String packageName = WSDescriptorParser.getPackageFromNamespace(namespace, mapping);
            StringBuffer buf = new StringBuffer(packageName.length() + typeQName.getLocalPart().length() + 14);
            buf.append(packageName).append(".holders.").append(typeQName.getLocalPart()).append("Holder");
            buf.setCharAt(packageName.length() + 9, Character.toUpperCase(typeQName.getLocalPart().charAt(0)));
            holderName = buf.toString();
        } else {
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            holder = (Class)rpcHolderClasses.get(paramJavaType);
            if (holder != null) {
                try {
                    holder = ClassLoading.loadClass((String)holder.getName(), (ClassLoader)classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("could not load holder type in correct classloader", (Throwable)e);
                }
                return holder;
            }
            String paramTypeName = paramJavaType.getName();
            StringBuffer buf = new StringBuffer(paramTypeName.length() + 14);
            int dot = paramTypeName.lastIndexOf(".");
            buf.append(paramTypeName.substring(0, dot)).append(".holders").append(paramTypeName.substring(dot)).append("Holder");
            holderName = buf.toString();
        }
        try {
            holder = ClassLoading.loadClass((String)holderName, (ClassLoader)classLoader);
            return holder;
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load holder class", (Throwable)e);
        }
    }

    public static ServiceEndpointMethodMappingType getMethodMappingForOperation(String operationName, ServiceEndpointMethodMappingType[] methodMappings) throws DeploymentException {
        for (int i = 0; i < methodMappings.length; ++i) {
            ServiceEndpointMethodMappingType methodMapping = methodMappings[i];
            if (!operationName.equals(methodMapping.getWsdlOperation().getStringValue())) continue;
            return methodMapping;
        }
        StringBuffer availOps = new StringBuffer(128);
        for (int i = 0; i < methodMappings.length; ++i) {
            if (i != 0) {
                availOps.append(",");
            }
            availOps.append(methodMappings[i].getWsdlOperation().getStringValue());
        }
        throw new DeploymentException("No method found for operation named '" + operationName + "'. Available operations: " + availOps);
    }

    public static ServiceEndpointInterfaceMappingType getServiceEndpointInterfaceMapping(ServiceEndpointInterfaceMappingType[] endpointMappings, QName portTypeQName) throws DeploymentException {
        for (int i = 0; i < endpointMappings.length; ++i) {
            ServiceEndpointInterfaceMappingType endpointMapping = endpointMappings[i];
            QName testPortQName = endpointMapping.getWsdlPortType().getQNameValue();
            if (!portTypeQName.equals(testPortQName)) continue;
            return endpointMapping;
        }
        throw new DeploymentException("Could not find service endpoint interface for port named " + portTypeQName);
    }

    public static Service getService(QName serviceQName, Definition definition) throws DeploymentException {
        Service service;
        if (serviceQName != null) {
            service = definition.getService(serviceQName);
        } else {
            Map services = definition.getServices();
            if (services.size() != 1) {
                throw new DeploymentException("no serviceQName supplied, and there are " + services.size() + " services");
            }
            service = (Service)services.values().iterator().next();
        }
        if (service == null) {
            throw new DeploymentException("No service wsdl for supplied service qname " + serviceQName);
        }
        return service;
    }

    public static Method getMethodForOperation(Class serviceEndpointInterface, Operation operation) throws DeploymentException {
        Method[] methods = serviceEndpointInterface.getMethods();
        String opName = operation.getName();
        Method found = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(opName)) continue;
            if (found != null) {
                throw new DeploymentException("Overloaded methods are not allowed in lightweight mappings");
            }
            found = method;
        }
        if (found == null) {
            throw new DeploymentException("No method found for operation named " + opName);
        }
        return found;
    }

    public static Map parseWebServiceDescriptor(WebservicesType webservicesType, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        HashMap<String, PortInfo> portMap = new HashMap<String, PortInfo>();
        WebserviceDescriptionType[] webserviceDescriptions = webservicesType.getWebserviceDescriptionArray();
        for (int i = 0; i < webserviceDescriptions.length; ++i) {
            WebserviceDescriptionType webserviceDescription = webserviceDescriptions[i];
            URI wsdlURI = null;
            try {
                wsdlURI = new URI(webserviceDescription.getWsdlFile().getStringValue().trim());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("could not construct wsdl uri from " + webserviceDescription.getWsdlFile().getStringValue(), (Throwable)e);
            }
            URI jaxrpcMappingURI = null;
            try {
                jaxrpcMappingURI = new URI(webserviceDescription.getJaxrpcMappingFile().getStringValue().trim());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not construct jaxrpc mapping uri from " + webserviceDescription.getJaxrpcMappingFile(), (Throwable)e);
            }
            SchemaInfoBuilder schemaInfoBuilder = new SchemaInfoBuilder(moduleFile, wsdlURI);
            Map wsdlPortMap = schemaInfoBuilder.getPortMap();
            JavaWsdlMappingType javaWsdlMapping = WSDescriptorParser.readJaxrpcMapping(moduleFile, jaxrpcMappingURI);
            HashMap<String, ServiceEndpointInterfaceMappingType> seiMappings = new HashMap<String, ServiceEndpointInterfaceMappingType>();
            ServiceEndpointInterfaceMappingType[] mappings = javaWsdlMapping.getServiceEndpointInterfaceMappingArray();
            for (int j = 0; j < mappings.length; ++j) {
                ServiceEndpointInterfaceMappingType seiMapping = mappings[j];
                seiMappings.put(seiMapping.getServiceEndpointInterface().getStringValue(), seiMapping);
            }
            PortComponentType[] portComponents = webserviceDescription.getPortComponentArray();
            for (int j = 0; j < portComponents.length; ++j) {
                String servletLocation;
                String linkName;
                PortComponentType portComponent = portComponents[j];
                String portComponentName = portComponent.getPortComponentName().getStringValue().trim();
                QName portQName = portComponent.getWsdlPort().getQNameValue();
                String seiInterfaceName = portComponent.getServiceEndpointInterface().getStringValue().trim();
                ServiceImplBeanType serviceImplBeanType = portComponent.getServiceImplBean();
                if (isEJB == serviceImplBeanType.isSetServletLink()) {
                    throw new DeploymentException("Wrong kind of web service described in web service descriptor: expected " + (isEJB ? "EJB" : "POJO(Servlet)"));
                }
                if (serviceImplBeanType.isSetServletLink()) {
                    linkName = serviceImplBeanType.getServletLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    if (servletLocation == null) {
                        throw new DeploymentException("No servlet mapping for port " + portQName);
                    }
                    schemaInfoBuilder.movePortLocation(portQName.getLocalPart(), servletLocation);
                } else {
                    linkName = serviceImplBeanType.getEjbLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    servletLocation = schemaInfoBuilder.movePortLocation(portQName.getLocalPart(), servletLocation);
                }
                PortComponentHandlerType[] handlers = portComponent.getHandlerArray();
                Port port = (Port)wsdlPortMap.get(portQName.getLocalPart());
                if (port == null) {
                    throw new DeploymentException("No WSDL Port definition for port-component " + portComponentName);
                }
                ServiceEndpointInterfaceMappingType seiMapping = (ServiceEndpointInterfaceMappingType)seiMappings.get(seiInterfaceName);
                String wsdlLocation = webserviceDescription.getWsdlFile().getStringValue().trim();
                URI contextURI = null;
                try {
                    contextURI = new URI(servletLocation);
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct URI for web service location", (Throwable)e);
                }
                PortInfo portInfo = new PortInfo(portComponentName, portQName, schemaInfoBuilder, javaWsdlMapping, seiInterfaceName, handlers, port, seiMapping, wsdlLocation, contextURI);
                if (portMap.put(linkName, portInfo) == null) continue;
                throw new DeploymentException("Ambiguous description of port associated with j2ee component " + linkName);
            }
        }
        return portMap;
    }

    public static Map parseWebServiceDescriptor(URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        try {
            WebservicesDocument webservicesDocument = WebservicesDocument.Factory.parse((URL)wsDDUrl);
            XmlBeansUtil.validateDD((XmlObject)webservicesDocument);
            WebservicesType webservicesType = webservicesDocument.getWebservices();
            return WSDescriptorParser.parseWebServiceDescriptor(webservicesType, moduleFile, isEJB, servletLocations);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not read descriptor document", (Throwable)e);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List createHandlerInfoList(PortComponentHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            PortComponentHandlerType handler = handlers[i];
            Class<?> handlerClass = null;
            String className = handler.getHandlerClass().getStringValue().trim();
            try {
                handlerClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Unable to load handler class: " + className, (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headers = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headers[j] = soapHeaderQName.getQNameValue();
            }
            list.add(new HandlerInfo(handlerClass, config, headers));
        }
        return list;
    }

    static {
        rpcHolderClasses.put(BigDecimal.class, BigDecimalHolder.class);
        rpcHolderClasses.put(BigInteger.class, BigIntegerHolder.class);
        rpcHolderClasses.put(Boolean.TYPE, BooleanHolder.class);
        rpcHolderClasses.put(Boolean.class, BooleanWrapperHolder.class);
        rpcHolderClasses.put([B.class, ByteArrayHolder.class);
        rpcHolderClasses.put(Byte.TYPE, ByteHolder.class);
        rpcHolderClasses.put(Byte.class, ByteWrapperHolder.class);
        rpcHolderClasses.put(Calendar.class, CalendarHolder.class);
        rpcHolderClasses.put(Double.TYPE, DoubleHolder.class);
        rpcHolderClasses.put(Double.class, DoubleWrapperHolder.class);
        rpcHolderClasses.put(Float.TYPE, FloatHolder.class);
        rpcHolderClasses.put(Float.class, FloatWrapperHolder.class);
        rpcHolderClasses.put(Integer.TYPE, IntHolder.class);
        rpcHolderClasses.put(Integer.class, IntegerWrapperHolder.class);
        rpcHolderClasses.put(Long.TYPE, LongHolder.class);
        rpcHolderClasses.put(Long.class, LongWrapperHolder.class);
        rpcHolderClasses.put(Object.class, ObjectHolder.class);
        rpcHolderClasses.put(QName.class, QNameHolder.class);
        rpcHolderClasses.put(Short.TYPE, ShortHolder.class);
        rpcHolderClasses.put(Short.class, ShortWrapperHolder.class);
        rpcHolderClasses.put(String.class, StringHolder.class);
    }
}

