/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.webservices.builder.SchemaTypeKey;
import org.apache.geronimo.webservices.builder.WSDescriptorParser;
import org.apache.geronimo.xbeans.wsdl.DefinitionsDocument;
import org.apache.geronimo.xbeans.wsdl.TDefinitions;
import org.apache.geronimo.xbeans.wsdl.TPort;
import org.apache.geronimo.xbeans.wsdl.TService;
import org.apache.xmlbeans.SchemaField;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaInfoBuilder {
    private static final Log log = LogFactory.getLog((Class)SchemaInfoBuilder.class);
    private static final SchemaTypeSystem basicTypeSystem;
    private static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName ADDRESS_QNAME;
    private static final QName LOCATION_QNAME;
    private final JarFile moduleFile;
    private final Definition definition;
    private final Stack uris = new Stack();
    private final Map wsdlMap = new HashMap();
    private final Map schemaTypeKeyToSchemaTypeMap;
    private final Map complexTypeMap;
    private final Map elementMap;
    private final Map simpleTypeMap;
    private final Map portMap;

    public SchemaInfoBuilder(JarFile moduleFile, URI wsdlUri) throws DeploymentException {
        this(moduleFile, wsdlUri, null, null);
    }

    public SchemaInfoBuilder(JarFile moduleFile, Definition definition) throws DeploymentException {
        this(moduleFile, null, definition, null);
    }

    SchemaInfoBuilder(JarFile moduleFile, URI uri, SchemaTypeSystem schemaTypeSystem) throws DeploymentException {
        this(moduleFile, uri, null, schemaTypeSystem);
    }

    SchemaInfoBuilder(JarFile moduleFile, URI uri, Definition definition, SchemaTypeSystem schemaTypeSystem) throws DeploymentException {
        this.moduleFile = moduleFile;
        if (uri != null) {
            this.uris.push(uri);
            if (definition == null && schemaTypeSystem == null) {
                definition = this.readWsdl(moduleFile, uri);
            }
        } else if (definition != null) {
            try {
                uri = new URI(definition.getDocumentBaseURI());
                this.uris.push(uri);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not locate definition", (Throwable)e);
            }
        } else {
            throw new DeploymentException("You must supply uri or definition");
        }
        if (schemaTypeSystem == null) {
            schemaTypeSystem = this.compileSchemaTypeSystem(definition);
        }
        this.definition = definition;
        this.schemaTypeKeyToSchemaTypeMap = this.buildSchemaTypeKeyToSchemaTypeMap(schemaTypeSystem);
        this.complexTypeMap = this.buildComplexTypeMap();
        this.simpleTypeMap = this.buildSimpleTypeMap();
        this.elementMap = this.buildElementMap();
        this.portMap = this.buildPortMap();
    }

    public Map getSchemaTypeKeyToSchemaTypeMap() {
        return this.schemaTypeKeyToSchemaTypeMap;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Map getWsdlMap() {
        return this.wsdlMap;
    }

    public Map getComplexTypesInWsdl() {
        return this.complexTypeMap;
    }

    private Map buildComplexTypeMap() {
        HashMap<QName, SchemaType> complexTypeMap = new HashMap<QName, SchemaType>();
        Iterator iterator = this.schemaTypeKeyToSchemaTypeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SchemaTypeKey key = (SchemaTypeKey)entry.getKey();
            if (key.isSimpleType() || key.isAnonymous()) continue;
            QName qName = key.getqName();
            SchemaType schemaType = (SchemaType)entry.getValue();
            complexTypeMap.put(qName, schemaType);
        }
        return complexTypeMap;
    }

    public Map getElementToTypeMap() {
        return this.elementMap;
    }

    private Map buildElementMap() {
        HashMap<QName, QName> elementToTypeMap = new HashMap<QName, QName>();
        Iterator iterator = this.schemaTypeKeyToSchemaTypeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SchemaTypeKey key = (SchemaTypeKey)entry.getKey();
            if (!key.isElement()) continue;
            QName elementQName = key.getqName();
            SchemaType schemaType = (SchemaType)entry.getValue();
            QName typeQName = schemaType.getName();
            elementToTypeMap.put(elementQName, typeQName);
        }
        return elementToTypeMap;
    }

    public Map getPortMap() {
        return this.portMap;
    }

    private Map buildPortMap() {
        HashMap ports = new HashMap();
        if (this.definition != null) {
            Collection services = this.definition.getServices().values();
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ports.putAll(service.getPorts());
            }
        }
        return ports;
    }

    public Map getSimpleTypeMap() {
        return this.simpleTypeMap;
    }

    private Map buildSimpleTypeMap() {
        HashMap<QName, SchemaType> simpleTypeMap = new HashMap<QName, SchemaType>();
        Iterator iterator = this.schemaTypeKeyToSchemaTypeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SchemaTypeKey key = (SchemaTypeKey)entry.getKey();
            if (!key.isSimpleType() || key.isAnonymous()) continue;
            QName qName = key.getqName();
            SchemaType schemaType = (SchemaType)entry.getValue();
            simpleTypeMap.put(qName, schemaType);
        }
        return simpleTypeMap;
    }

    public SchemaTypeSystem compileSchemaTypeSystem(Definition definition) throws DeploymentException {
        ArrayList schemaList = new ArrayList();
        this.addImportsFromDefinition(definition, schemaList);
        ArrayList errors = new ArrayList();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setErrorListener(errors);
        xmlOptions.setEntityResolver((EntityResolver)new JarEntityResolver());
        XmlObject[] schemas = schemaList.toArray(new XmlObject[schemaList.size()]);
        try {
            SchemaTypeSystem schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)basicTypeSystem, (XmlOptions)xmlOptions);
            if (errors.size() > 0) {
                boolean wasError = false;
                Iterator iterator = errors.iterator();
                while (iterator.hasNext()) {
                    XmlError xmlError = (XmlError)iterator.next();
                    if (xmlError.getSeverity() == 0) {
                        log.error((Object)xmlError);
                        wasError = true;
                        continue;
                    }
                    if (xmlError.getSeverity() == 1) {
                        log.warn((Object)xmlError);
                        continue;
                    }
                    if (xmlError.getSeverity() != 2) continue;
                    log.debug((Object)xmlError);
                }
                if (wasError) {
                    throw new DeploymentException("Could not compile schema type system, see log for errors");
                }
            }
            return schemaTypeSystem;
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not compile schema type system: " + schemaList, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportsFromDefinition(Definition definition, List schemaList) throws DeploymentException {
        Map imports;
        Iterator<Object> iterator;
        Map namespaceMap = definition.getNamespaces();
        Types types = definition.getTypes();
        if (types != null) {
            List schemas = types.getExtensibilityElements();
            iterator = schemas.iterator();
            while (iterator.hasNext()) {
                Schema unknownExtensibilityElement;
                Object o = iterator.next();
                if (o instanceof Schema) {
                    unknownExtensibilityElement = (Schema)o;
                    QName elementType = unknownExtensibilityElement.getElementType();
                    if (!new QName("http://www.w3.org/2001/XMLSchema", "schema").equals(elementType)) continue;
                    Element element = unknownExtensibilityElement.getElement();
                    this.addSchemaElement(element, namespaceMap, schemaList);
                    continue;
                }
                if (!(o instanceof UnknownExtensibilityElement)) continue;
                unknownExtensibilityElement = (UnknownExtensibilityElement)o;
                Element element = unknownExtensibilityElement.getElement();
                String elementNamespace = element.getNamespaceURI();
                String elementLocalName = element.getNodeName();
                if (!"http://www.w3.org/2001/XMLSchema".equals(elementNamespace) || !"schema".equals(elementLocalName)) continue;
                this.addSchemaElement(element, namespaceMap, schemaList);
            }
        }
        if ((imports = definition.getImports()) != null) {
            iterator = imports.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String namespaceURI = (String)entry.getKey();
                List importList = (List)entry.getValue();
                Iterator iterator1 = importList.iterator();
                while (iterator1.hasNext()) {
                    Import anImport = (Import)iterator1.next();
                    Definition definition1 = anImport.getDefinition();
                    if (definition1 != null) {
                        try {
                            URI uri = new URI(definition1.getDocumentBaseURI());
                            this.uris.push(uri);
                        }
                        catch (URISyntaxException e) {
                            throw new DeploymentException("Could not locate definition", (Throwable)e);
                        }
                        try {
                            this.addImportsFromDefinition(definition1, schemaList);
                            continue;
                        }
                        finally {
                            this.uris.pop();
                            continue;
                        }
                    }
                    log.warn((Object)("Missing definition in import for namespace " + namespaceURI));
                }
            }
        }
    }

    private void addSchemaElement(Element element, Map namespaceMap, List schemaList) throws DeploymentException {
        try {
            XmlObject xmlObject = SchemaInfoBuilder.parseWithNamespaces(element, namespaceMap);
            schemaList.add(xmlObject);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse schema element", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XmlObject parseWithNamespaces(Element element, Map namespaceMap) throws XmlException {
        ArrayList errors = new ArrayList();
        XmlOptions xmlOptions = XmlBeansUtil.createXmlOptions(errors);
        SchemaDocument parsed = SchemaDocument.Factory.parse((Node)element, (XmlOptions)xmlOptions);
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        XmlCursor cursor = parsed.newCursor();
        try {
            cursor.toFirstContentToken();
            Iterator namespaces = namespaceMap.entrySet().iterator();
            while (namespaces.hasNext()) {
                Map.Entry entry = namespaces.next();
                cursor.insertNamespace((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            cursor.dispose();
        }
        return parsed;
    }

    private Map buildSchemaTypeKeyToSchemaTypeMap(SchemaTypeSystem schemaTypeSystem) {
        HashMap qnameMap = new HashMap();
        SchemaType[] globalTypes = schemaTypeSystem.globalTypes();
        for (int i = 0; i < globalTypes.length; ++i) {
            SchemaType globalType = globalTypes[i];
            QName typeQName = globalType.getName();
            this.addSchemaType(typeQName, globalType, false, qnameMap);
        }
        SchemaGlobalElement[] globalElements = schemaTypeSystem.globalElements();
        for (int i = 0; i < globalElements.length; ++i) {
            SchemaGlobalElement globalElement = globalElements[i];
            this.addElement((SchemaField)globalElement, null, qnameMap);
        }
        return qnameMap;
    }

    private void addElement(SchemaField element, SchemaTypeKey key, Map qnameMap) {
        SchemaTypeKey elementKey;
        String elementQNameLocalName;
        QName elementName = element.getName();
        String elementNamespace = elementName.getNamespaceURI();
        if (elementNamespace == null || elementNamespace.equals("")) {
            elementNamespace = key.getqName().getNamespaceURI();
        }
        if (key == null) {
            elementQNameLocalName = elementName.getLocalPart();
            elementKey = new SchemaTypeKey(elementName, true, false, false, elementName);
        } else {
            QName enclosingTypeQName = key.getqName();
            String enclosingTypeLocalName = enclosingTypeQName.getLocalPart();
            elementQNameLocalName = enclosingTypeLocalName + ">" + elementName.getLocalPart();
            QName subElementName = new QName(elementNamespace, elementQNameLocalName);
            elementKey = new SchemaTypeKey(subElementName, true, false, true, elementName);
        }
        SchemaType schemaType = element.getType();
        qnameMap.put(elementKey, schemaType);
        if (element instanceof SchemaParticle) {
            this.addArrayForms((SchemaParticle)element, elementKey.getqName(), qnameMap, schemaType);
        } else {
            log.warn((Object)("element is not a schemaParticle! " + element));
        }
        String typeQNameLocalPart = ">" + elementQNameLocalName;
        QName typeQName = new QName(elementNamespace, typeQNameLocalPart);
        boolean isAnonymous = true;
        this.addSchemaType(typeQName, schemaType, isAnonymous, qnameMap);
    }

    private void addSchemaType(QName typeQName, SchemaType schemaType, boolean anonymous, Map qnameMap) {
        SchemaTypeKey typeKey = new SchemaTypeKey(typeQName, false, schemaType.isSimpleType(), anonymous, null);
        qnameMap.put(typeKey, schemaType);
        SchemaParticle schemaParticle = schemaType.getContentModel();
        if (schemaParticle != null) {
            this.addSchemaParticle(schemaParticle, typeKey, qnameMap);
        }
    }

    private void addSchemaParticle(SchemaParticle schemaParticle, SchemaTypeKey key, Map qnameMap) {
        if (schemaParticle.getParticleType() == 4) {
            SchemaType elementType = schemaParticle.getType();
            SchemaField element = elementType.getContainerField();
            if (element != null) {
                this.addElement(element, key, qnameMap);
            } else {
                QName keyQName = key.getqName();
                String localPart = schemaParticle.getName().getLocalPart();
                QName elementName = new QName(keyQName.getNamespaceURI(), localPart);
                this.addArrayForms(schemaParticle, elementName, qnameMap, elementType);
                localPart = keyQName.getLocalPart() + ">" + schemaParticle.getName().getLocalPart();
                elementName = new QName(keyQName.getNamespaceURI(), localPart);
                this.addArrayForms(schemaParticle, elementName, qnameMap, elementType);
            }
        } else {
            try {
                SchemaParticle[] children = schemaParticle.getParticleChildren();
                for (int i = 0; i < children.length; ++i) {
                    SchemaParticle child = children[i];
                    this.addSchemaParticle(child, key, qnameMap);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    private void addArrayForms(SchemaParticle schemaParticle, QName keyName, Map qnameMap, SchemaType elementType) {
        if (schemaParticle.getIntMaxOccurs() > 1) {
            String maxOccurs = schemaParticle.getMaxOccurs() == null ? "unbounded" : "" + schemaParticle.getIntMaxOccurs();
            int minOccurs = schemaParticle.getIntMinOccurs();
            QName elementName = schemaParticle.getName();
            String arrayQNameLocalName = keyName.getLocalPart() + "[" + minOccurs + "," + maxOccurs + "]";
            String elementNamespace = elementName.getNamespaceURI();
            if (elementNamespace == null || elementNamespace.equals("")) {
                elementNamespace = keyName.getNamespaceURI();
            }
            QName arrayName = new QName(elementNamespace, arrayQNameLocalName);
            SchemaTypeKey arrayKey = new SchemaTypeKey(arrayName, false, false, true, elementName);
            qnameMap.put(arrayKey, elementType);
            if (minOccurs == 1) {
                arrayQNameLocalName = keyName.getLocalPart() + "[," + maxOccurs + "]";
                arrayName = new QName(elementNamespace, arrayQNameLocalName);
                arrayKey = new SchemaTypeKey(arrayName, false, false, true, elementName);
                qnameMap.put(arrayKey, elementType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition readWsdl(JarFile moduleFile, URI wsdlURI) throws DeploymentException {
        Definition definition;
        WSDLFactory wsdlFactory;
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new DeploymentException("Could not create WSDLFactory", (Throwable)e);
        }
        WSDLReader wsdlReaderNoImport = wsdlFactory.newWSDLReader();
        wsdlReaderNoImport.setFeature("javax.wsdl.importDocuments", false);
        PopulatedExtensionRegistry extensionRegistry = new PopulatedExtensionRegistry();
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_1999, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, extensionRegistry.getDefaultSerializer());
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2000, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, extensionRegistry.getDefaultSerializer());
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2001, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, extensionRegistry.getDefaultSerializer());
        wsdlReaderNoImport.setExtensionRegistry((ExtensionRegistry)extensionRegistry);
        JarWSDLLocator wsdlLocator = new JarWSDLLocator(wsdlURI);
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                definition = wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
            }
            catch (WSDLException e) {
                throw new DeploymentException("Failed to read wsdl document", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(oldCl);
        }
        return definition;
    }

    public static ExtensibilityElement getExtensibilityElement(Class clazz, List extensibilityElements) throws DeploymentException {
        Iterator iterator = extensibilityElements.iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            return extensibilityElement;
        }
        throw new DeploymentException("No element of class " + clazz.getName() + " found");
    }

    public String movePortLocation(String portComponentName, String servletLocation) throws DeploymentException {
        DefinitionsDocument doc = (DefinitionsDocument)this.wsdlMap.get(this.uris.get(0));
        TDefinitions definitions = doc.getDefinitions();
        TService[] services = definitions.getServiceArray();
        for (int i = 0; i < services.length; ++i) {
            TService service = services[i];
            TPort[] ports = service.getPortArray();
            for (int j = 0; j < ports.length; ++j) {
                TPort port = ports[j];
                if (!port.getName().trim().equals(portComponentName)) continue;
                XmlCursor portCursor = port.newCursor();
                try {
                    String original;
                    if (!portCursor.toChild(ADDRESS_QNAME)) continue;
                    if (servletLocation == null) {
                        original = portCursor.getAttributeText(LOCATION_QNAME);
                        URI originalURI = new URI(original);
                        servletLocation = originalURI.getPath();
                    }
                    portCursor.setAttributeText(LOCATION_QNAME, "LOCATIONREPLACEMENTTOKEN" + servletLocation);
                    original = servletLocation;
                    return original;
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct URI for ejb location in wsdl", (Throwable)e);
                }
                finally {
                    portCursor.dispose();
                }
            }
        }
        throw new DeploymentException("No port found with name " + portComponentName + " expected at " + servletLocation);
    }

    static {
        ADDRESS_QNAME = new QName(SOAP_NS, "address");
        LOCATION_QNAME = new QName("", "location");
        InputStream is = WSDescriptorParser.class.getClassLoader().getResourceAsStream("META-INF/schema/soap_encoding_1_1.xsd");
        if (is == null) {
            throw new RuntimeException("Could not locate soap encoding schema");
        }
        ArrayList errors = new ArrayList();
        XmlOptions xmlOptions = XmlBeansUtil.createXmlOptions(errors);
        try {
            SchemaDocument parsed = SchemaDocument.Factory.parse((InputStream)is, (XmlOptions)xmlOptions);
            if (errors.size() != 0) {
                throw new XmlException(errors.toArray().toString());
            }
            basicTypeSystem = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{parsed}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)xmlOptions);
            if (errors.size() > 0) {
                throw new RuntimeException("Could not compile schema type system: errors: " + errors);
            }
        }
        catch (XmlException e) {
            throw new RuntimeException("Could not compile schema type system", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compile schema type system", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
    }

    class JarWSDLLocator
    implements WSDLLocator {
        private final List streams = new ArrayList();
        private final URI wsdlURI;
        private URI latestImportURI;

        public JarWSDLLocator(URI wsdlURI) {
            this.wsdlURI = wsdlURI;
        }

        public InputSource getBaseInputSource() {
            InputStream wsdlInputStream;
            ZipEntry entry = SchemaInfoBuilder.this.moduleFile.getEntry(this.wsdlURI.toString());
            if (entry == null) {
                throw new RuntimeException("The webservices.xml file for the EJB JAR points to a non-existant WSDL file " + this.wsdlURI.toString());
            }
            try {
                wsdlInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
                DefinitionsDocument definition = DefinitionsDocument.Factory.parse(wsdlInputStream);
                SchemaInfoBuilder.this.wsdlMap.put(this.wsdlURI, definition);
                wsdlInputStream.close();
                wsdlInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
                this.streams.add(wsdlInputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not open stream to wsdl file", e);
            }
            return new InputSource(wsdlInputStream);
        }

        public String getBaseURI() {
            return this.wsdlURI.toString();
        }

        public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
            InputStream importInputStream;
            URI parentURI = URI.create(parentLocation);
            this.latestImportURI = parentURI.resolve(relativeLocation);
            try {
                ZipEntry entry = SchemaInfoBuilder.this.moduleFile.getEntry(this.latestImportURI.toString());
                importInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
                try {
                    DefinitionsDocument definition = DefinitionsDocument.Factory.parse(importInputStream);
                    importInputStream.close();
                    SchemaInfoBuilder.this.wsdlMap.put(this.latestImportURI, definition);
                    importInputStream.close();
                }
                catch (XmlException e) {
                    // empty catch block
                }
                importInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
                this.streams.add(importInputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not open stream to import file", e);
            }
            InputSource inputSource = new InputSource(importInputStream);
            inputSource.setSystemId(this.getLatestImportURI());
            return inputSource;
        }

        public String getLatestImportURI() {
            return this.latestImportURI.toString();
        }

        public void close() {
            Iterator iterator = this.streams.iterator();
            while (iterator.hasNext()) {
                InputStream inputStream = (InputStream)iterator.next();
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.streams.clear();
        }
    }

    private class JarEntityResolver
    implements EntityResolver {
        private static final String PROJECT_URL_PREFIX = "project://local/";

        private JarEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputStream wsdlInputStream;
            if (systemId.indexOf(PROJECT_URL_PREFIX) > -1) {
                systemId = systemId.substring(PROJECT_URL_PREFIX.length());
            }
            URI location = ((URI)SchemaInfoBuilder.this.uris.peek()).resolve(systemId);
            try {
                ZipEntry entry = SchemaInfoBuilder.this.moduleFile.getEntry(location.toString());
                wsdlInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
                SchemaDocument xmlObject = SchemaDocument.Factory.parse((InputStream)wsdlInputStream);
                SchemaInfoBuilder.this.wsdlMap.put(location, xmlObject);
                wsdlInputStream.close();
                wsdlInputStream = SchemaInfoBuilder.this.moduleFile.getInputStream(entry);
            }
            catch (XmlException e) {
                throw (IOException)new IOException("Could not parse schema document").initCause(e);
            }
            return new InputSource(wsdlInputStream);
        }
    }
}

