/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.web.security.HTTPMethods;
import org.apache.geronimo.web.security.URLPatternCheck;

public class URLPattern {
    public static final int NA = 0;
    public static final int INTEGRAL = 1;
    public static final int CONFIDENTIAL = 2;
    private final URLPatternCheck type;
    private final String pattern;
    private final HTTPMethods httpMethods;
    private int transport;
    private final HashSet<String> roles = new HashSet();
    private static final URLPatternCheck EXACT = new URLPatternCheck(){

        @Override
        public boolean check(URLPattern base, URLPattern test) {
            return this.matches(base.pattern, test.pattern);
        }

        @Override
        public boolean matches(String base, String test) {
            return base.equals(test);
        }
    };
    private static final URLPatternCheck PATH_PREFIX = new URLPatternCheck(){

        @Override
        public boolean check(URLPattern base, URLPattern test) {
            return (test.type == PATH_PREFIX || test.type == EXACT) && base.matches(test) && !base.equals(test);
        }

        @Override
        public boolean matches(String base, String test) {
            int length = base.length() - 2;
            if (length > test.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (base.charAt(i) == test.charAt(i)) continue;
                return false;
            }
            if (test.length() == length) {
                return true;
            }
            return test.charAt(length) == '/';
        }
    };
    private static final URLPatternCheck EXTENSION = new URLPatternCheck(){

        @Override
        public boolean check(URLPattern base, URLPattern test) {
            if (test.type == PATH_PREFIX) {
                return true;
            }
            if (test.type == EXACT) {
                return this.matches(base.pattern, test.pattern);
            }
            return false;
        }

        @Override
        public boolean matches(String base, String test) {
            return test.endsWith(base.substring(1));
        }
    };
    private static final URLPatternCheck DEFAULT = new URLPatternCheck(){

        @Override
        public boolean check(URLPattern base, URLPattern test) {
            return base.matches(test) && !base.equals(test);
        }

        @Override
        public boolean matches(String base, String test) {
            return true;
        }
    };

    public URLPattern(String pat, Set<String> methods, boolean isHttpMethodExcluded) {
        if (pat == null) {
            throw new IllegalArgumentException("URL pattern cannot be null");
        }
        if (pat.length() == 0) {
            throw new IllegalArgumentException("URL pattern cannot be empty");
        }
        if (pat.equals("/") || pat.equals("/*")) {
            this.type = DEFAULT;
            pat = "/";
        } else {
            this.type = pat.charAt(0) == '/' && pat.endsWith("/*") ? PATH_PREFIX : (pat.charAt(0) == '*' ? EXTENSION : EXACT);
        }
        this.pattern = pat;
        this.httpMethods = new HTTPMethods(methods, isHttpMethodExcluded);
    }

    public String getQualifiedPattern(Set<URLPattern> patterns) {
        if (this.type == EXACT) {
            return this.pattern;
        }
        StringBuilder result = new StringBuilder(this.pattern);
        for (URLPattern p : patterns) {
            if (!this.type.check(this, p)) continue;
            result.append(':');
            result.append(p.pattern);
        }
        return result.toString();
    }

    public void addMethods(Set<String> methods, boolean isExcluded) {
        this.httpMethods.add(methods, isExcluded);
    }

    public boolean removeMethods(URLPattern other) {
        return this.httpMethods.remove(other.getHTTPMethods()) != null;
    }

    public String getMethods() {
        return this.httpMethods.getHttpMethods();
    }

    public String getComplementedMethods() {
        return this.httpMethods.getComplementedHttpMethods();
    }

    public HTTPMethods getHTTPMethods() {
        return this.httpMethods;
    }

    public HTTPMethods getComplementedHTTPMethods() {
        return new HTTPMethods(this.httpMethods, true);
    }

    public String getMethodsWithTransport() {
        return URLPattern.getMethodsWithTransport(this.httpMethods, this.transport);
    }

    public static String getMethodsWithTransport(HTTPMethods methods, int transport) {
        StringBuilder buffer = methods.getHttpMethodsBuffer();
        if (transport != 0) {
            buffer.append(":");
            if (transport != 3) {
                if (transport == 1) {
                    buffer.append("INTEGRAL");
                } else {
                    buffer.append("CONFIDENTIAL");
                }
            }
        }
        return buffer.toString();
    }

    public void setTransport(String trans) {
        switch (this.transport) {
            case 0: {
                if ("INTEGRAL".equals(trans)) {
                    this.transport = 1;
                    break;
                }
                if (!"CONFIDENTIAL".equals(trans)) break;
                this.transport = 2;
                break;
            }
            case 1: {
                if (!"CONFIDENTIAL".equals(trans)) break;
                this.transport = 2;
            }
        }
    }

    public int getTransport() {
        return this.transport;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addAllRoles(Collection<String> collection) {
        this.roles.addAll(collection);
    }

    public HashSet<String> getRoles() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLPattern)) {
            return false;
        }
        URLPattern test = (URLPattern)obj;
        return this.pattern.equals(test.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    boolean matches(URLPattern p) {
        String test = p.pattern;
        if (this.pattern.equals(test)) {
            return true;
        }
        return this.type.matches(this.pattern, test);
    }
}

