/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.openejb.jee.SecurityConstraint;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;
import org.apache.openejb.jee.WebResourceCollection;

public class SecurityConstraintMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (SecurityConstraint securityConstraint : webFragment.getSecurityConstraint()) {
            for (WebResourceCollection webResourceCollection : securityConstraint.getWebResourceCollection()) {
                for (String urlPattern : webResourceCollection.getUrlPattern()) {
                    if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", webResourceCollection.getWebResourceName(), urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
                }
                this.validateHTTPMethods(webResourceCollection.getHttpMethod(), mergeContext.getCurrentJarUrl());
                this.validateHTTPMethods(webResourceCollection.getHttpMethodOmission(), mergeContext.getCurrentJarUrl());
            }
            webApp.getSecurityConstraint().add(securityConstraint);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (SecurityConstraint securityConstraint : webApp.getSecurityConstraint()) {
            for (WebResourceCollection webResourceCollection : securityConstraint.getWebResourceCollection()) {
                for (String urlPattern : webResourceCollection.getUrlPattern()) {
                    if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", webResourceCollection.getWebResourceName(), urlPattern, "web.xml "));
                }
                this.validateHTTPMethods(webResourceCollection.getHttpMethod(), "web.xml");
                this.validateHTTPMethods(webResourceCollection.getHttpMethodOmission(), "web.xml");
            }
        }
    }

    private void validateHTTPMethods(List<String> httpMethods, String source) throws DeploymentException {
        for (String httpMethod : httpMethods) {
            if (WebDeploymentValidationUtils.isValidHTTPMethod(httpMethod)) continue;
            throw new DeploymentException("Invalid HTTP method value is found in " + source);
        }
    }
}

