/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class PersistenceContextRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String PERSISTENCE_CONTEXT_REF_NAME_PREFIX = "persistence-context-ref.persistence-context-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceContextRef srcPersistenceContextRef : webFragment.getPersistenceContextRef()) {
            String persistenceContextRefName = srcPersistenceContextRef.getPersistenceContextRefName();
            String persistenceContextRefKey = PersistenceContextRefMergeHandler.createPersistenceContextRefKey(persistenceContextRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(persistenceContextRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("persistence-context-ref", persistenceContextRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || PersistenceContextRefMergeHandler.isPersistenceContextRefInjectTargetsConfiguredInInitialWebXML(persistenceContextRefName, mergeContext)) continue;
                PersistenceContextRef persistenceContextRef = (PersistenceContextRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcPersistenceContextRef.getInjectionTarget()) {
                    String persistenceContextRefInjectTargetKey = PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(persistenceContextRefInjectTargetKey)) continue;
                    persistenceContextRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(persistenceContextRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getPersistenceContextRef().add(srcPersistenceContextRef);
            mergeContext.setAttribute(persistenceContextRefKey, new MergeItem(srcPersistenceContextRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcPersistenceContextRef.getInjectionTarget()) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceContextRef persistenceContextRef : webApp.getPersistenceContextRef()) {
            String persistenceContextRefName = persistenceContextRef.getPersistenceContextRefName();
            mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefKey(persistenceContextRefName), new MergeItem(persistenceContextRef, null, ElementSource.WEB_XML));
            if (!persistenceContextRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(persistenceContextRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : persistenceContextRef.getInjectionTarget()) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(String persistenceContextRefName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createPersistenceContextRefInjectTargetKey(String persistenceContextRefName, String injectTargetClassName, String injectTargetName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createPersistenceContextRefKey(String persistenceContextRefName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName;
    }

    public static boolean isPersistenceContextRefInjectTargetConfigured(String persistenceContextRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isPersistenceContextRefInjectTargetsConfiguredInInitialWebXML(String persistenceContextRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(persistenceContextRefName));
    }
}

