/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingDispatcherMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingServletNameMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingUrlPatternMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class FilterMappingMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    private List<SubMergeHandler<FilterMapping, FilterMapping>> subMergeHandlers = new ArrayList<SubMergeHandler<FilterMapping, FilterMapping>>(3);

    public FilterMappingMergeHandler() {
        this.subMergeHandlers.add(new FilterMappingUrlPatternMergeHandler());
        this.subMergeHandlers.add(new FilterMappingServletNameMergeHandler());
        this.subMergeHandlers.add(new FilterMappingDispatcherMergeHandler());
    }

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (FilterMapping srcFilterMapping : webFragment.getFilterMapping()) {
            String filterName = srcFilterMapping.getFilterName();
            FilterMapping targetFilterMapping = (FilterMapping)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
            if (targetFilterMapping == null) {
                webApp.getFilterMapping().add(srcFilterMapping);
                mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName), srcFilterMapping);
                for (SubMergeHandler<FilterMapping, FilterMapping> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(srcFilterMapping, mergeContext);
                }
                continue;
            }
            if (FilterMappingMergeHandler.isFilterMappingFromWebXml(filterName, mergeContext)) continue;
            if (FilterMappingMergeHandler.isFilterMappingFromAnnotation(filterName, mergeContext)) {
                targetFilterMapping.getUrlPattern().clear();
                targetFilterMapping.getDispatcher().clear();
                targetFilterMapping.getServletName().clear();
                mergeContext.removeAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName));
            }
            for (SubMergeHandler<FilterMapping, FilterMapping> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcFilterMapping, targetFilterMapping, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (SubMergeHandler<FilterMapping, FilterMapping> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, context);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (FilterMapping filterMapping : webApp.getFilterMapping()) {
            String filterName = filterMapping.getFilterName();
            context.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName), filterMapping);
            context.setAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName), (Object)ElementSource.WEB_XML);
        }
        for (SubMergeHandler subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, context);
        }
    }

    public static String createFilterMappingKey(String filterName) {
        return "filter-mapping.filter-name" + filterName;
    }

    public static boolean isFilterMappingConfigured(String filterName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
    }

    public static FilterMapping getFilterMapping(String filterName, MergeContext mergeContext) {
        return (FilterMapping)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
    }

    public static String createFilterMappingSourceKey(String filterName) {
        return "filter-mapping.filter-name." + filterName + ".sources";
    }

    public static boolean isFilterMappingFromAnnotation(String filterName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.ANNOTATION);
    }

    public static boolean isFilterMappingFromWebXml(String filterName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.WEB_XML);
    }

    public static void addFilterMapping(FilterMapping filterMapping, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterMapping.getFilterName()), filterMapping);
    }
}

