/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebFilterAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMergeHandler;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.MultipartConfig;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.WebApp;

public class WebServletAnnotationMergeHandler
implements AnnotationMergeHandler {
    @Override
    public void merge(Class<?>[] classes, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            String[] urlPatterns;
            boolean urlPatternsAttributeConfigured;
            if (!HttpServlet.class.isAssignableFrom(cls)) {
                throw new DeploymentException("The class " + cls.getName() + " with WebServlet annotation must extend javax.servlet.HttpServlet");
            }
            WebServlet webServlet = cls.getAnnotation(WebServlet.class);
            boolean valueAttributeConfigured = webServlet.value().length > 0;
            boolean bl = urlPatternsAttributeConfigured = webServlet.urlPatterns().length > 0;
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                throw new DeploymentException("value and urlPatterns must not be configured on the same WebServlet annotation in the class " + cls.getName());
            }
            if (!valueAttributeConfigured && !urlPatternsAttributeConfigured) {
                throw new DeploymentException("At least one of value and urlPatterns attribute should be configured on the WebServlet annotation in the class " + cls.getName());
            }
            String servletName = webServlet.name().length() == 0 ? cls.getName() : webServlet.name();
            String[] stringArray = urlPatterns = valueAttributeConfigured ? webServlet.value() : webServlet.urlPatterns();
            if (ServletMergeHandler.isServletConfigured(servletName, mergeContext)) {
                Servlet targetServlet = ServletMergeHandler.getServlet(servletName, mergeContext);
                for (WebInitParam webInitParam : webServlet.initParams()) {
                    String paramName = webInitParam.name();
                    if (ServletInitParamMergeHandler.isServletInitParamConfigured(servletName, paramName, mergeContext)) continue;
                    ParamValue newParamValue = WebFilterAnnotationMergeHandler.newParamValue(webInitParam);
                    targetServlet.getInitParam().add(newParamValue);
                    ServletInitParamMergeHandler.addServletInitParam(servletName, newParamValue, ElementSource.ANNOTATION, mergeContext.getCurrentJarUrl(), mergeContext);
                }
            } else {
                javax.servlet.annotation.MultipartConfig multipartConfig;
                Servlet newServlet = new Servlet();
                if (!webServlet.displayName().isEmpty()) {
                    newServlet.addDisplayName(new Text(null, webServlet.displayName()));
                }
                newServlet.setServletClass(cls.getName());
                newServlet.setServletName(servletName);
                newServlet.setAsyncSupported(Boolean.valueOf(webServlet.asyncSupported()));
                if (!webServlet.description().isEmpty()) {
                    newServlet.addDescription(new Text(null, webServlet.description()));
                }
                if (webServlet.loadOnStartup() != -1) {
                    newServlet.setLoadOnStartup(Integer.valueOf(webServlet.loadOnStartup()));
                }
                for (WebInitParam webInitParam : webServlet.initParams()) {
                    newServlet.getInitParam().add(WebFilterAnnotationMergeHandler.newParamValue(webInitParam));
                }
                if (!webServlet.smallIcon().isEmpty() || !webServlet.largeIcon().isEmpty()) {
                    Icon icon = new Icon();
                    if (!webServlet.smallIcon().isEmpty()) {
                        icon.setSmallIcon(webServlet.smallIcon());
                    }
                    if (!webServlet.largeIcon().isEmpty()) {
                        icon.setLargeIcon(webServlet.largeIcon());
                    }
                    newServlet.getIconMap().put(null, icon);
                }
                if ((multipartConfig = cls.getAnnotation(javax.servlet.annotation.MultipartConfig.class)) != null) {
                    MultipartConfig mpc = new MultipartConfig();
                    mpc.setFileSizeThreshold(multipartConfig.fileSizeThreshold());
                    mpc.setLocation(multipartConfig.location());
                    mpc.setMaxFileSize(multipartConfig.maxFileSize());
                    mpc.setMaxRequestSize(multipartConfig.maxRequestSize());
                    newServlet.setMultipartConfig(mpc);
                }
                webApp.getServlet().add(newServlet);
                ServletMergeHandler.addServlet(newServlet, mergeContext);
            }
            if (ServletMappingMergeHandler.isServletMappingConfigured(servletName, mergeContext)) continue;
            ServletMapping newServletMapping = new ServletMapping();
            newServletMapping.setServletName(servletName);
            for (String string : urlPatterns) {
                newServletMapping.getUrlPattern().add(string);
            }
            webApp.getServletMapping().add(newServletMapping);
            ServletMappingMergeHandler.addServletMapping(newServletMapping, mergeContext);
            mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName), (Object)ElementSource.ANNOTATION);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

