/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.CookieConfig;
import org.apache.openejb.jee.SessionConfig;
import org.apache.openejb.jee.TrackingMode;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class SessionConfigMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        if (webFragment.getSessionConfig().size() == 1) {
            this.mergeSessionConfig(webApp, (SessionConfig)webFragment.getSessionConfig().get(0), mergeContext, ElementSource.WEB_FRAGMENT);
        } else if (webFragment.getSessionConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebFragmentErrorMessage("session-config", mergeContext.getCurrentJarUrl()));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        if (webApp.getSessionConfig().size() == 1) {
            SessionConfig sessionConfig = (SessionConfig)webApp.getSessionConfig().get(0);
            this.mergeSessionConfig(webApp, sessionConfig, context, ElementSource.WEB_XML);
            context.setAttribute("session-config", sessionConfig);
        } else if (webApp.getSessionConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("session-config"));
        }
    }

    private CookieConfig getCookieConfig(WebApp webApp, MergeContext context) {
        SessionConfig sessionConfig = this.getSessionConfig(webApp, context);
        if (sessionConfig.getCookieConfig() == null) {
            sessionConfig.setCookieConfig(new CookieConfig());
        }
        return sessionConfig.getCookieConfig();
    }

    private SessionConfig getSessionConfig(WebApp webApp, MergeContext context) {
        SessionConfig sessionConfig = (SessionConfig)context.getAttribute("session-config");
        if (sessionConfig == null) {
            sessionConfig = new SessionConfig();
            webApp.getSessionConfig().add(sessionConfig);
            context.setAttribute("session-config", sessionConfig);
        }
        return sessionConfig;
    }

    private void mergeSessionConfig(WebApp webApp, SessionConfig sessionConfig, MergeContext context, ElementSource elementSource) throws DeploymentException {
        if (sessionConfig.getSessionTimeout() != null && this.mergeSingleAttribute(context, "timeout", "session-config.session-timeout", "" + sessionConfig.getSessionTimeout(), null, elementSource)) {
            this.getSessionConfig(webApp, context).setSessionTimeout(sessionConfig.getSessionTimeout());
        }
        if (sessionConfig.getCookieConfig() != null) {
            CookieConfig cookieConfig = sessionConfig.getCookieConfig();
            if (cookieConfig.getName() != null && this.mergeSingleAttribute(context, "name", "session-config.cookie-config.name", cookieConfig.getName(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setName(cookieConfig.getName());
            }
            if (cookieConfig.getDomain() != null && this.mergeSingleAttribute(context, "domain", "session-config.cookie-config.domain", cookieConfig.getDomain(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setDomain(cookieConfig.getDomain());
            }
            if (cookieConfig.getPath() != null && this.mergeSingleAttribute(context, "path", "session-config.cookie-config.path", cookieConfig.getPath(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setPath(cookieConfig.getPath());
            }
            if (cookieConfig.getComment() != null && this.mergeSingleAttribute(context, "comment", "session-config.cookie-config.comment", cookieConfig.getComment(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setComment(cookieConfig.getComment());
            }
            if (cookieConfig.getHttpOnly() != null && this.mergeSingleAttribute(context, "http-only", "session-config.cookie-config.http-only", "" + cookieConfig.getHttpOnly(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setHttpOnly(cookieConfig.getHttpOnly());
            }
            if (cookieConfig.getSecure() != null && this.mergeSingleAttribute(context, "secure", "session-config.cookie-config.secure", "" + cookieConfig.getSecure(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setSecure(cookieConfig.getSecure());
            }
            if (cookieConfig.getMaxAge() != null && this.mergeSingleAttribute(context, "max-age", "session-config.cookie-config.max-age", "" + cookieConfig.getMaxAge(), null, elementSource)) {
                this.getCookieConfig(webApp, context).setMaxAge(cookieConfig.getMaxAge());
            }
        }
        if (elementSource.equals((Object)ElementSource.WEB_FRAGMENT) && !sessionConfig.getTrackingMode().isEmpty()) {
            for (TrackingMode trackingMode : sessionConfig.getTrackingMode()) {
                if (context.containsAttribute("session-config.tracking-mode." + trackingMode)) continue;
                this.getSessionConfig(webApp, context).getTrackingMode().add(trackingMode);
                context.setAttribute("session-config.tracking-mode." + trackingMode, Boolean.TRUE);
            }
        }
    }

    private boolean mergeSingleAttribute(MergeContext mergeContext, String elementName, String key, String value, String jarUrl, ElementSource elementSource) throws DeploymentException {
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(key);
        if (mergeItem != null) {
            if (mergeItem.getSourceType().equals((Object)ElementSource.WEB_FRAGMENT) && !mergeItem.getValue().equals(value)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage("session-config", elementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, jarUrl));
            }
            return false;
        }
        mergeContext.setAttribute(key, new MergeItem(value, jarUrl, elementSource));
        return elementSource.equals((Object)ElementSource.WEB_FRAGMENT);
    }
}

