/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class PersistenceUnitRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String PERSISTENCE_UNIT_REF_NAME_PREFIX = "persistence-unit-ref.persistence-unit-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceUnitRef srcPersistenceUnitRef : webFragment.getPersistenceUnitRef()) {
            String persistenceUnitRefName = srcPersistenceUnitRef.getPersistenceUnitRefName();
            String persistenceUnitRefKey = PersistenceUnitRefMergeHandler.createPersistenceUnitRefKey(persistenceUnitRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(persistenceUnitRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("persistence-unit-ref", persistenceUnitRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || PersistenceUnitRefMergeHandler.isPersistenceUnitRefInjectTargetsConfiguredInInitialWebXML(persistenceUnitRefName, mergeContext)) continue;
                PersistenceUnitRef persistenceUnitRef = (PersistenceUnitRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcPersistenceUnitRef.getInjectionTarget()) {
                    String persistenceUnitRefInjectTargetKey = PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(persistenceUnitRefInjectTargetKey)) continue;
                    persistenceUnitRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(persistenceUnitRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getPersistenceUnitRef().add(srcPersistenceUnitRef);
            mergeContext.setAttribute(persistenceUnitRefKey, new MergeItem(srcPersistenceUnitRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcPersistenceUnitRef.getInjectionTarget()) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceUnitRef persistenceUnitRef : webApp.getPersistenceUnitRef()) {
            String persistenceUnitRefName = persistenceUnitRef.getPersistenceUnitRefName();
            mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefKey(persistenceUnitRefName), new MergeItem(persistenceUnitRef, null, ElementSource.WEB_XML));
            if (!persistenceUnitRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(persistenceUnitRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : persistenceUnitRef.getInjectionTarget()) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(String persistenceUnitRefName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createPersistenceUnitRefInjectTargetKey(String persistenceUnitRefName, String injectTargetClassName, String injectTargetName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createPersistenceUnitRefKey(String persistenceUnitRefName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName;
    }

    public static boolean isPersistenceUnitRefInjectTargetConfigured(String persistenceUnitRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isPersistenceUnitRefInjectTargetsConfiguredInInitialWebXML(String persistenceUnitRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(persistenceUnitRefName));
    }
}

