/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.WebApp;

public class FilterMappingServletNameMergeHandler
implements SubMergeHandler<FilterMapping, FilterMapping> {
    @Override
    public void add(FilterMapping filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName();
        for (String servletName : filterMapping.getServletName()) {
            mergeContext.setAttribute(FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName), Boolean.TRUE);
        }
    }

    @Override
    public void merge(FilterMapping srcFilterMapping, FilterMapping targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName();
        for (String servletName : srcFilterMapping.getServletName()) {
            String filterMappingServletNameKey = FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName);
            if (mergeContext.containsAttribute(filterMappingServletNameKey)) continue;
            targetFilterMapping.getServletName().add(servletName);
            mergeContext.setAttribute(filterMappingServletNameKey, Boolean.TRUE);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (FilterMapping filterMapping : webApp.getFilterMapping()) {
            String filterName = filterMapping.getFilterName();
            for (String servletName : filterMapping.getServletName()) {
                context.setAttribute(FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName), Boolean.TRUE);
            }
        }
    }

    public static String createFilterMappingServletNameKey(String filterName, String servletName) {
        return "filter-mapping.filter-name." + filterName + ".servlet-name." + servletName;
    }
}

