/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ListenerMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Listener listener : webFragment.getListener()) {
            String listenerClassName = listener.getListenerClass();
            if (mergeContext.containsAttribute(ListenerMergeHandler.createListenerKey(listenerClassName))) continue;
            webApp.getListener().add(listener);
            mergeContext.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass()), listener);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (Listener listener : webApp.getListener()) {
            context.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass()), listener);
        }
    }

    public static String createListenerKey(String listenerClassName) {
        return "listener.listener-class." + listenerClassName;
    }

    public static boolean isListenerConfigured(String listenerClassName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ListenerMergeHandler.createListenerKey(listenerClassName));
    }

    public static void addListener(Listener listener, MergeContext mergeContext) {
        mergeContext.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass()), listener);
    }
}

