/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeHelper;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.JspPropertyGroup;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspConfigMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    private static final Logger logger = LoggerFactory.getLogger(JspConfigMergeHandler.class);

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        if (webFragment.getJspConfig().isEmpty()) {
            return;
        }
        if (webFragment.getJspConfig().size() > 1) {
            logger.warn(WebDeploymentMessageUtils.createMultipleConfigurationWarningMessage("jsp-config", mergeContext.getCurrentJarUrl()));
        }
        JspConfig srcJspConfig = (JspConfig)webFragment.getJspConfig().get(0);
        if (webApp.getJspConfig().isEmpty()) {
            webApp.getJspConfig().add(new JspConfig());
        }
        JspConfig targetJspConfig = (JspConfig)webApp.getJspConfig().get(0);
        for (Taglib taglib : srcJspConfig.getTaglib()) {
            if (!MergeHelper.mergeRequired(JspConfigMergeHandler.createTaglibKey(taglib), "jsp-config/tag-lib", "taglib-uri", taglib.getTaglibUri(), "taglib-location", taglib.getTaglibLocation(), mergeContext)) continue;
            targetJspConfig.getTaglib().add(taglib);
        }
        for (JspPropertyGroup srcJspPropertyGroup : srcJspConfig.getJspPropertyGroup()) {
            targetJspConfig.getJspPropertyGroup().add(srcJspPropertyGroup);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        if (webApp.getJspConfig().isEmpty()) {
            return;
        }
        if (webApp.getJspConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("jsp-config"));
        }
        JspConfig jspConfig = (JspConfig)webApp.getJspConfig().get(0);
        for (Taglib taglib : jspConfig.getTaglib()) {
            context.setAttribute(JspConfigMergeHandler.createTaglibKey(taglib), new MergeItem(taglib.getTaglibLocation(), null, ElementSource.WEB_XML));
        }
    }

    public static String createTaglibKey(Taglib taglib) {
        return "jsp-config.taglib.taglib-uri." + taglib.getTaglibUri();
    }
}

