/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class EnvEntryMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String ENV_ENTRY_NAME_PREFIX = "env-entry.env-entry-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EnvEntry srcEnvEntry : webFragment.getEnvEntry()) {
            String envEntryName = srcEnvEntry.getEnvEntryName();
            String envEntryKey = EnvEntryMergeHandler.createEnvEntryKey(envEntryName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(envEntryKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("env-entry", envEntryName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EnvEntryMergeHandler.isEnvEntryInjectTargetsConfiguredInInitialWebXML(envEntryName, mergeContext)) continue;
                EnvEntry envEntry = (EnvEntry)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcEnvEntry.getInjectionTarget()) {
                    String envEntryInjectTargetKey = EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(envEntryInjectTargetKey)) continue;
                    envEntry.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(envEntryInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getEnvEntry().add(srcEnvEntry);
            mergeContext.setAttribute(envEntryKey, new MergeItem(srcEnvEntry, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcEnvEntry.getInjectionTarget()) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EnvEntry envEntry : webApp.getEnvEntry()) {
            String envEntryName = envEntry.getEnvEntryName();
            mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryKey(envEntryName), new MergeItem(envEntry, null, ElementSource.WEB_XML));
            if (envEntry.getInjectionTarget().size() > 0) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetConfiguredInWebXMLKey(envEntryName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : envEntry.getInjectionTarget()) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createEnvEntryInjectTargetConfiguredInWebXMLKey(String envEntryName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName + ".inject_target_configured_in_web_xml";
    }

    public static String createEnvEntryInjectTargetKey(String envEntryName, String injectTargetClassName, String injectTargetName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEnvEntryKey(String envEntryName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName;
    }

    public static boolean isEnvEntryInjectTargetConfigured(String envEntryName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEnvEntryInjectTargetsConfiguredInInitialWebXML(String envEntryName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetConfiguredInWebXMLKey(envEntryName));
    }
}

