/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.CookieConfigType;
import org.apache.geronimo.xbeans.javaee6.SessionConfigType;
import org.apache.geronimo.xbeans.javaee6.TrackingModeType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class SessionConfigMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        if (webFragment.getSessionConfigArray().length == 1) {
            this.mergeSessionConfig(webApp, webFragment.getSessionConfigArray(0), mergeContext, ElementSource.WEB_FRAGMENT);
        } else if (webFragment.getSessionConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebFragmentErrorMessage("session-config", mergeContext.getCurrentJarUrl()));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        if (webApp.getSessionConfigArray().length == 1) {
            SessionConfigType sessionConfig = webApp.getSessionConfigArray(0);
            this.mergeSessionConfig(webApp, sessionConfig, context, ElementSource.WEB_XML);
            context.setAttribute("session-config", sessionConfig);
        } else if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("session-config"));
        }
    }

    private CookieConfigType getCookieConfig(WebAppType webApp, MergeContext context) {
        SessionConfigType sessionConfig = this.getSessionConfig(webApp, context);
        if (sessionConfig.isSetCookieConfig()) {
            return sessionConfig.getCookieConfig();
        }
        return sessionConfig.addNewCookieConfig();
    }

    private SessionConfigType getSessionConfig(WebAppType webApp, MergeContext context) {
        SessionConfigType sessionConfig = (SessionConfigType)context.getAttribute("session-config");
        if (sessionConfig == null) {
            sessionConfig = webApp.addNewSessionConfig();
            context.setAttribute("session-config", sessionConfig);
        }
        return sessionConfig;
    }

    private void mergeSessionConfig(WebAppType webApp, SessionConfigType sessionConfig, MergeContext context, ElementSource elementSource) throws DeploymentException {
        if (sessionConfig.isSetSessionTimeout() && this.mergeSingleAttribute(context, "timeout", "session-config.session-timeout", sessionConfig.getSessionTimeout().getStringValue(), null, elementSource)) {
            this.getSessionConfig(webApp, context).addNewSessionTimeout().set((XmlObject)sessionConfig.getSessionTimeout());
        }
        if (sessionConfig.isSetCookieConfig()) {
            CookieConfigType cookieConfig = sessionConfig.getCookieConfig();
            if (cookieConfig.isSetName() && this.mergeSingleAttribute(context, "name", "session-config.cookie-config.name", cookieConfig.getName().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewName().set((XmlObject)cookieConfig.getName());
            }
            if (cookieConfig.isSetDomain() && this.mergeSingleAttribute(context, "domain", "session-config.cookie-config.domain", cookieConfig.getDomain().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewDomain().set((XmlObject)cookieConfig.getDomain());
            }
            if (cookieConfig.isSetPath() && this.mergeSingleAttribute(context, "path", "session-config.cookie-config.path", cookieConfig.getPath().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewPath().set((XmlObject)cookieConfig.getPath());
            }
            if (cookieConfig.isSetComment() && this.mergeSingleAttribute(context, "comment", "session-config.cookie-config.comment", cookieConfig.getComment().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewComment().set((XmlObject)cookieConfig.getComment());
            }
            if (cookieConfig.isSetHttpOnly() && this.mergeSingleAttribute(context, "http-only", "session-config.cookie-config.http-only", cookieConfig.getHttpOnly().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewHttpOnly().set((XmlObject)cookieConfig.getHttpOnly());
            }
            if (cookieConfig.isSetSecure() && this.mergeSingleAttribute(context, "secure", "session-config.cookie-config.secure", cookieConfig.getSecure().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewSecure().set((XmlObject)cookieConfig.getSecure());
            }
            if (cookieConfig.isSetMaxAge() && this.mergeSingleAttribute(context, "max-age", "session-config.cookie-config.max-age", cookieConfig.getMaxAge().getStringValue(), null, elementSource)) {
                this.getCookieConfig(webApp, context).addNewMaxAge().set((XmlObject)cookieConfig.getMaxAge());
            }
        }
        if (elementSource.equals((Object)ElementSource.WEB_FRAGMENT) && sessionConfig.getTrackingModeArray().length > 0) {
            for (TrackingModeType trackingMode : sessionConfig.getTrackingModeArray()) {
                if (context.containsAttribute("session-config.tracking-mode." + trackingMode.getStringValue())) continue;
                this.getSessionConfig(webApp, context).addNewTrackingMode().set((XmlObject)trackingMode);
                context.setAttribute("session-config.tracking-mode." + trackingMode.getStringValue(), Boolean.TRUE);
            }
        }
    }

    private boolean mergeSingleAttribute(MergeContext mergeContext, String elementName, String key, String value, String jarUrl, ElementSource elementSource) throws DeploymentException {
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(key);
        if (mergeItem != null) {
            if (mergeItem.getSourceType().equals((Object)ElementSource.WEB_FRAGMENT) && !mergeItem.getValue().equals(value)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage("session-config", elementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, jarUrl));
            }
            return false;
        }
        mergeContext.setAttribute(key, new MergeItem(value, jarUrl, elementSource));
        return elementSource.equals((Object)ElementSource.WEB_FRAGMENT);
    }
}

