/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.ServiceRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ServiceRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String SERVICE_REF_NAME_PREFIX = "service-ref.service-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServiceRefType srcServiceRef : webFragment.getServiceRefArray()) {
            String serviceRefName = srcServiceRef.getServiceRefName().getStringValue();
            String serviceRefKey = ServiceRefMergeHandler.createServiceRefKey(serviceRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(serviceRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("service-ref", serviceRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ServiceRefMergeHandler.isServiceRefInjectTargetsConfiguredInInitialWebXML(serviceRefName, mergeContext)) continue;
                ServiceRefType serviceRef = (ServiceRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcServiceRef.getInjectionTargetArray()) {
                    String serviceRefInjectTargetKey = ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(serviceRefInjectTargetKey)) continue;
                    serviceRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(serviceRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            ServiceRefType targetServiceRef = (ServiceRefType)webApp.addNewServiceRef().set((XmlObject)srcServiceRef);
            mergeContext.setAttribute(serviceRefKey, new MergeItem(targetServiceRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetServiceRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServiceRefType serviceRef : webApp.getServiceRefArray()) {
            String serviceRefName = serviceRef.getServiceRefName().getStringValue();
            mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefKey(serviceRefName), new MergeItem(serviceRef, null, ElementSource.WEB_XML));
            if (serviceRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetConfiguredInWebXMLKey(serviceRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : serviceRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createServiceRefInjectTargetConfiguredInWebXMLKey(String serviceRefName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createServiceRefInjectTargetKey(String serviceRefName, String injectTargetClassName, String injectTargetName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createServiceRefKey(String serviceRefName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName;
    }

    public static boolean isServiceRefInjectTargetConfigured(String serviceRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isServiceRefInjectTargetsConfiguredInInitialWebXML(String serviceRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetConfiguredInWebXMLKey(serviceRefName));
    }
}

