/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.geronimo.xbeans.javaee6.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.geronimo.xbeans.javaee6.WebResourceCollectionType;
import org.apache.xmlbeans.XmlObject;

public class SecurityConstraintMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (SecurityConstraintType securityConstraint : webApp.getSecurityConstraintArray()) {
            for (WebResourceCollectionType webResourceCollection : securityConstraint.getWebResourceCollectionArray()) {
                for (UrlPatternType pattern : webResourceCollection.getUrlPatternArray()) {
                    String urlPattern = pattern.getStringValue();
                    if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", webResourceCollection.getWebResourceName().getStringValue(), urlPattern, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
                }
                this.validateHTTPMethods(webResourceCollection.getHttpMethodArray(), mergeContext.getCurrentJarUrl());
                this.validateHTTPMethods(webResourceCollection.getHttpMethodOmissionArray(), mergeContext.getCurrentJarUrl());
            }
            webApp.addNewSecurityConstraint().set((XmlObject)securityConstraint);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (SecurityConstraintType securityConstraint : webApp.getSecurityConstraintArray()) {
            for (WebResourceCollectionType webResourceCollection : securityConstraint.getWebResourceCollectionArray()) {
                for (UrlPatternType pattern : webResourceCollection.getUrlPatternArray()) {
                    String urlPattern = pattern.getStringValue();
                    if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern)) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", webResourceCollection.getWebResourceName().getStringValue(), urlPattern, "web.xml "));
                }
                this.validateHTTPMethods(webResourceCollection.getHttpMethodArray(), "web.xml");
                this.validateHTTPMethods(webResourceCollection.getHttpMethodOmissionArray(), "web.xml");
            }
        }
    }

    private void validateHTTPMethods(String[] httpMethods, String source) throws DeploymentException {
        for (String httpMethod : httpMethods) {
            if (WebDeploymentValidationUtils.isValidHTTPMethod(httpMethod)) continue;
            throw new DeploymentException("Invalid HTTP method value is found in " + source);
        }
    }
}

