/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.FilterType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class FilterMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    private List<SubMergeHandler<FilterType, FilterType>> subMergeHandlers = new ArrayList<SubMergeHandler<FilterType, FilterType>>();

    public FilterMergeHandler() {
        this.subMergeHandlers.add(new FilterInitParamMergeHandler());
    }

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (FilterType srcFilter : webFragment.getFilterArray()) {
            String filterName = srcFilter.getFilterName().getStringValue();
            FilterType targetFilter = (FilterType)mergeContext.getAttribute(FilterMergeHandler.createFilterKey(filterName));
            if (targetFilter == null) {
                targetFilter = (FilterType)webApp.addNewFilter().set((XmlObject)srcFilter);
                mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filterName), targetFilter);
                for (SubMergeHandler<FilterType, FilterType> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(targetFilter, mergeContext);
                }
                continue;
            }
            for (SubMergeHandler<FilterType, FilterType> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcFilter, targetFilter, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (SubMergeHandler<FilterType, FilterType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, mergeContext);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (FilterType filter : webApp.getFilterArray()) {
            mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filter.getFilterName().getStringValue()), filter);
        }
        for (SubMergeHandler<FilterType, FilterType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
    }

    public static String createFilterKey(String filterName) {
        return "filter.filter-name." + filterName;
    }

    public static boolean isFilterConfigured(String filterName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMergeHandler.createFilterKey(filterName));
    }

    public static FilterType getFilter(String filterName, MergeContext mergeContext) {
        return (FilterType)mergeContext.getAttribute(FilterMergeHandler.createFilterKey(filterName));
    }

    public static void addFilter(FilterType filter, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filter.getFilterName().getStringValue()), filter);
    }
}

