/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xmlbeans.XmlObject;

public class FilterMappingUrlPatternMergeHandler
implements SubMergeHandler<FilterMappingType, FilterMappingType> {
    @Override
    public void add(FilterMappingType filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName().getStringValue();
        for (UrlPatternType urlPattern : filterMapping.getUrlPatternArray()) {
            String urlPatternStr = urlPattern.getStringValue();
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPatternStr, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPatternStr), urlPattern);
        }
    }

    @Override
    public void merge(FilterMappingType srcFilterMapping, FilterMappingType targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName().getStringValue();
        for (UrlPatternType urlPattern : srcFilterMapping.getUrlPatternArray()) {
            String urlPatternStr = urlPattern.getStringValue();
            String filterMappingUrlPatternKey = FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPatternStr);
            if (mergeContext.containsAttribute(filterMappingUrlPatternKey)) continue;
            UrlPatternType newUrlPattern = (UrlPatternType)targetFilterMapping.addNewUrlPattern().set((XmlObject)urlPattern);
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPatternStr, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(filterMappingUrlPatternKey, newUrlPattern);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (FilterMappingType filterMapping : webApp.getFilterMappingArray()) {
            String filterName = filterMapping.getFilterName().getStringValue();
            for (UrlPatternType urlPattern : filterMapping.getUrlPatternArray()) {
                String urlPatternStr = urlPattern.getStringValue();
                if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterName, urlPatternStr, "web.xml"));
                }
                context.setAttribute(FilterMappingUrlPatternMergeHandler.createFilterMappingUrlPatternKey(filterName, urlPatternStr), urlPattern);
            }
        }
    }

    public static String createFilterMappingUrlPatternKey(String filterName, String urlPattern) {
        return "filter-mapping.filter-name." + filterName + ".url-pattern." + urlPattern;
    }
}

