/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingDispatcherMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingServletNameMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingUrlPatternMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.DispatcherType;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletNameType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class FilterMappingMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    private List<SubMergeHandler<FilterMappingType, FilterMappingType>> subMergeHandlers = new ArrayList<SubMergeHandler<FilterMappingType, FilterMappingType>>();

    public FilterMappingMergeHandler() {
        this.subMergeHandlers.add(new FilterMappingUrlPatternMergeHandler());
        this.subMergeHandlers.add(new FilterMappingServletNameMergeHandler());
        this.subMergeHandlers.add(new FilterMappingDispatcherMergeHandler());
    }

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (FilterMappingType srcFilterMapping : webFragment.getFilterMappingArray()) {
            String filterName = srcFilterMapping.getFilterName().getStringValue();
            FilterMappingType targetFilterMapping = (FilterMappingType)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
            if (targetFilterMapping == null) {
                targetFilterMapping = (FilterMappingType)webApp.addNewFilterMapping().set((XmlObject)srcFilterMapping);
                mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName), targetFilterMapping);
                for (SubMergeHandler<FilterMappingType, FilterMappingType> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(targetFilterMapping, mergeContext);
                }
                continue;
            }
            if (FilterMappingMergeHandler.isFilterMappingFromAnnotation(filterName, mergeContext)) {
                targetFilterMapping.setUrlPatternArray(new UrlPatternType[0]);
                targetFilterMapping.setDispatcherArray(new DispatcherType[0]);
                targetFilterMapping.setServletNameArray(new ServletNameType[0]);
                mergeContext.removeAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName));
            }
            for (SubMergeHandler<FilterMappingType, FilterMappingType> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcFilterMapping, targetFilterMapping, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (SubMergeHandler<FilterMappingType, FilterMappingType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, context);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (FilterMappingType filterMapping : webApp.getFilterMappingArray()) {
            String filterName = filterMapping.getFilterName().getStringValue();
            context.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName), filterMapping);
        }
        for (SubMergeHandler<FilterMappingType, FilterMappingType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, context);
        }
    }

    public static String createFilterMappingKey(String filterName) {
        return "filter-mapping.filter-name" + filterName;
    }

    public static boolean isFilterMappingConfigured(String filterName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
    }

    public static FilterMappingType getFilterMappingType(String filterName, MergeContext mergeContext) {
        return (FilterMappingType)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterName));
    }

    public static String createFilterMappingSourceKey(String filterName) {
        return "filter-mapping.filter-name." + filterName + ".sources";
    }

    public static boolean isFilterMappingFromAnnotation(String filterName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(FilterMappingMergeHandler.createFilterMappingSourceKey(filterName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.ANNOTATION);
    }

    public static void addFilterMapping(FilterMappingType filterMapping, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterMappingMergeHandler.createFilterMappingKey(filterMapping.getFilterName().getStringValue()), filterMapping);
    }
}

