/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.ErrorPageType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ErrorPageMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ErrorPageType errorPage : webFragment.getErrorPageArray()) {
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage));
            if (mergeItem != null) {
                if (mergeItem.getSourceType().equals((Object)ElementSource.WEB_XML) || !mergeItem.getValue().equals(errorPage.getLocation().getStringValue())) continue;
                boolean isErrorCodeConfigured = errorPage.getErrorCode() != null;
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("error-page", isErrorCodeConfigured ? "error-code" : "exception-type", isErrorCodeConfigured ? errorPage.getErrorCode().getStringValue() : errorPage.getExceptionType().getStringValue(), "location", (String)mergeItem.getValue(), mergeItem.getBelongedURL(), errorPage.getLocation().getStringValue(), mergeContext.getCurrentJarUrl()));
            }
            webApp.addNewErrorPage().set((XmlObject)errorPage);
            mergeContext.setAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage), new MergeItem(errorPage.getLocation().getStringValue(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ErrorPageType errorPage : webApp.getErrorPageArray()) {
            context.setAttribute(ErrorPageMergeHandler.createErrorPageKey(errorPage), new MergeItem(errorPage.getLocation().getStringValue(), null, ElementSource.WEB_XML));
        }
    }

    public static final String createErrorCodeKey(String errorCode) {
        return "error-page.error-code." + errorCode;
    }

    public static final String createExceptionTypeKey(String exceptionType) {
        return "error-page.exception-type." + exceptionType;
    }

    public static final String createErrorPageKey(ErrorPageType errorPage) {
        return errorPage.getErrorCode() == null ? ErrorPageMergeHandler.createExceptionTypeKey(errorPage.getExceptionType().getStringValue()) : ErrorPageMergeHandler.createErrorCodeKey(errorPage.getErrorCode().getStringValue());
    }
}

