/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.EjbLocalRefType;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class EjbLocalRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String EJB_LOCAL_REF_NAME_PREFIX = "ejb-local-ref.ejb-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbLocalRefType srcEjbLocalRef : webFragment.getEjbLocalRefArray()) {
            String ejbLocalRefName = srcEjbLocalRef.getEjbRefName().getStringValue();
            String ejbLocalRefKey = EjbLocalRefMergeHandler.createEjbLocalRefKey(ejbLocalRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ejbLocalRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("ejb-local-ref", ejbLocalRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EjbLocalRefMergeHandler.isEjbLocalRefInjectTargetsConfiguredInInitialWebXML(ejbLocalRefName, mergeContext)) continue;
                EjbLocalRefType ejbLocalRef = (EjbLocalRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcEjbLocalRef.getInjectionTargetArray()) {
                    String ejbLocalRefInjectTargetKey = EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(ejbLocalRefInjectTargetKey)) continue;
                    ejbLocalRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(ejbLocalRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            EjbLocalRefType targetEjbLocalRef = (EjbLocalRefType)webApp.addNewEjbLocalRef().set((XmlObject)srcEjbLocalRef);
            mergeContext.setAttribute(ejbLocalRefKey, new MergeItem(targetEjbLocalRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetEjbLocalRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbLocalRefType ejbLocalRef : webApp.getEjbLocalRefArray()) {
            String ejbLocalRefName = ejbLocalRef.getEjbRefName().getStringValue();
            mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefKey(ejbLocalRefName), new MergeItem(ejbLocalRef, null, ElementSource.WEB_XML));
            if (ejbLocalRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetConfiguredInWebXMLKey(ejbLocalRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : ejbLocalRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createEjbLocalRefInjectTargetConfiguredInWebXMLKey(String ejbLocalRefName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createEjbLocalRefInjectTargetKey(String ejbLocalRefName, String injectTargetClassName, String injectTargetName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEjbLocalRefKey(String ejbLocalRefName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName;
    }

    public static boolean isEjbLocalRefInjectTargetConfigured(String ejbLocalRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEjbLocalRefInjectTargetsConfiguredInInitialWebXML(String ejbLocalRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetConfiguredInWebXMLKey(ejbLocalRefName));
    }
}

