/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import javax.servlet.Servlet;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.osgi.framework.Bundle;

public class ServletSecurityAnnotationMergeHandler
implements AnnotationMergeHandler {
    @Override
    public void merge(Class<?>[] classes, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        try {
            Bundle bundle = mergeContext.getBundle();
            for (ServletType servlet : webApp.getServletArray()) {
                ServletSecurity servletSecurity;
                String servletClassName;
                Class cls;
                if (servlet.getServletClass() == null || servlet.getServletClass().getStringValue().isEmpty() || !Servlet.class.isAssignableFrom(cls = bundle.loadClass(servletClassName = servlet.getServletClass().getStringValue())) || (servletSecurity = cls.getAnnotation(ServletSecurity.class)) == null) continue;
                if (servletSecurity.httpMethodConstraints().length > 0) {
                    for (HttpMethodConstraint httpMethodConstraint : servletSecurity.httpMethodConstraints()) {
                        String httpMethod = httpMethodConstraint.value();
                        if (httpMethod == null || httpMethod.trim().isEmpty()) {
                            throw new DeploymentException("HTTP protocol method could not be null or empty string in the ServletSecurity annotation of the class " + servletClassName);
                        }
                        if (WebDeploymentValidationUtils.isValidHTTPMethod(httpMethod = httpMethod.trim())) continue;
                        throw new DeploymentException("Invalid HTTP method value is found in the ServletSecurity annotation of the class " + servletClassName);
                    }
                    continue;
                }
                HttpConstraint httpConstraint = servletSecurity.value();
                if (httpConstraint.rolesAllowed().length <= 0 || !httpConstraint.value().equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) continue;
                throw new DeploymentException("EmptyRoleSemantic with value DENY is not allowed in combination with a non-empty rolesAllowed list in the class " + servletClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Fail to load servlet class", (Throwable)e);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

