/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.components.jaspi.model.AuthModuleType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.JaspiXmlUtil;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.SecurityAnnotationHelper;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jaspi.AuthConfigProviderGBean;
import org.apache.geronimo.security.jaspi.ServerAuthConfigGBean;
import org.apache.geronimo.security.jaspi.ServerAuthContextGBean;
import org.apache.geronimo.security.jaspi.ServerAuthModuleGBean;
import org.apache.geronimo.web25.deployment.security.AuthenticationWrapper;
import org.apache.geronimo.web25.deployment.security.SpecSecurityBuilder;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.javaee.FilterMappingType;
import org.apache.geronimo.xbeans.javaee.FilterType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.ListenerType;
import org.apache.geronimo.xbeans.javaee.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee.ServletMappingType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.UrlPatternType;
import org.apache.geronimo.xbeans.javaee.WebAppDocument;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.geronimo.xbeans.javaee.WebResourceCollectionType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebModuleBuilder
implements ModuleBuilder {
    public static final NamingBuilder.Key<GBeanData> DEFAULT_JSP_SERVLET_KEY = new NamingBuilder.Key<GBeanData>(){

        public GBeanData get(Map context) {
            return (GBeanData)context.get(this);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(AbstractWebModuleBuilder.class);
    private static final QName TAGLIB = new QName("http://java.sun.com/xml/ns/javaee", "taglib");
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected static final AbstractNameQuery MANAGED_CONNECTION_FACTORY_PATTERN;
    private static final AbstractNameQuery ADMIN_OBJECT_PATTERN;
    protected static final AbstractNameQuery STATELESS_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery STATEFUL_SESSION_BEAN_PATTERN;
    protected static final AbstractNameQuery ENTITY_BEAN_PATTERN;
    protected final Kernel kernel;
    protected final NamespaceDrivenBuilderCollection serviceBuilders;
    protected final ResourceEnvironmentSetter resourceEnvironmentSetter;
    protected final Collection<WebServiceBuilder> webServiceBuilder;
    protected final NamingBuilder namingBuilders;
    protected final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private static final QName SECURITY_QNAME;
    private static final URI RELATIVE_MODULE_BASE_URI;

    protected AbstractWebModuleBuilder(Kernel kernel, Collection<NamespaceDrivenBuilder> serviceBuilders, NamingBuilder namingBuilders, ResourceEnvironmentSetter resourceEnvironmentSetter, Collection<WebServiceBuilder> webServiceBuilder, Collection<ModuleBuilderExtension> moduleBuilderExtensions) {
        this.kernel = kernel;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders);
        this.namingBuilders = namingBuilders;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        this.webServiceBuilder = webServiceBuilder;
        this.moduleBuilderExtensions = moduleBuilderExtensions == null ? new ArrayList() : moduleBuilderExtensions;
    }

    public NamingBuilder getNamingBuilders() {
        return this.namingBuilders;
    }

    protected void addGBeanDependencies(EARContext earContext, GBeanData webModuleData) {
        Configuration earConfiguration = earContext.getConfiguration();
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, MANAGED_CONNECTION_FACTORY_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ADMIN_OBJECT_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATELESS_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, STATEFUL_SESSION_BEAN_PATTERN), webModuleData);
        this.addDependencies(earContext.findGBeanDatas(earConfiguration, ENTITY_BEAN_PATTERN), webModuleData);
    }

    private void addDependencies(LinkedHashSet<GBeanData> dependencies, GBeanData webModuleData) {
        for (GBeanData dependency : dependencies) {
            AbstractName dependencyName = dependency.getAbstractName();
            webModuleData.addDependency(dependencyName);
        }
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, ".", null, true, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false, (String)moduleContextInfo, earName, naming, idBuilder);
    }

    protected abstract Module createModule(Object var1, JarFile var2, String var3, URL var4, boolean var5, String var6, AbstractName var7, Naming var8, ModuleIDBuilder var9) throws DeploymentException;

    protected Map<String, String> buildServletNameToPathMap(WebAppType webApp, String contextRoot) {
        ServletMappingType[] servletMappings;
        if (contextRoot == null) {
            contextRoot = "";
        } else if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            String servletName = servletMapping.getServletName().getStringValue().trim();
            UrlPatternType[] urlPatterns = servletMapping.getUrlPatternArray();
            for (int i = 0; urlPatterns != null && i < urlPatterns.length; ++i) {
                map.put(servletName, contextRoot + urlPatterns[i].getStringValue().trim());
            }
        }
        return map;
    }

    protected String determineDefaultContextRoot(WebAppType webApp, boolean isStandAlone, JarFile moduleFile, String targetPath) {
        if (webApp != null && webApp.getId() != null) {
            return webApp.getId();
        }
        if (isStandAlone) {
            return "/" + this.trimPath(new File(moduleFile.getName()).getName());
        }
        return this.trimPath(targetPath);
    }

    private String trimPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".war")) {
            path = path.substring(0, path.length() - 4);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        EARContext moduleContext;
        if (module.isStandAlone()) {
            moduleContext = earContext;
        } else {
            Environment environment = module.getEnvironment();
            Artifact earConfigId = earContext.getConfigID();
            Artifact configId = new Artifact(earConfigId.getGroupId(), earConfigId.getArtifactId() + "_" + module.getTargetPath(), earConfigId.getVersion(), "car");
            environment.setConfigId(configId);
            environment.addDependency(earConfigId, ImportType.ALL);
            File configurationDir = new File(earContext.getBaseDir(), module.getTargetPath());
            configurationDir.mkdirs();
            try {
                File inPlaceConfigurationDir = null;
                if (null != earContext.getInPlaceConfigurationDir()) {
                    inPlaceConfigurationDir = new File(earContext.getInPlaceConfigurationDir(), module.getTargetPath());
                }
                moduleContext = new EARContext(configurationDir, inPlaceConfigurationDir, environment, ConfigurationModuleType.WAR, module.getModuleName(), earContext);
            }
            catch (DeploymentException e) {
                this.cleanupConfigurationDir(configurationDir);
                throw e;
            }
        }
        module.setEarContext(moduleContext);
        module.setRootEarContext(earContext);
        try {
            ClassPathList manifestcp = new ClassPathList();
            JarFile warFile = module.getModuleFile();
            Enumeration<JarEntry> entries = warFile.entries();
            ArrayList<ZipEntry> libs = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI targetPath = new URI(null, entry.getName(), null);
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    moduleContext.addFile(targetPath, module.getOriginalSpecDD());
                    continue;
                }
                if (entry.getName().startsWith("WEB-INF/lib") && entry.getName().endsWith(".jar")) {
                    libs.add(entry);
                    continue;
                }
                moduleContext.addFile(targetPath, (ZipFile)warFile, entry);
            }
            moduleContext.getConfiguration().addToClassPath("WEB-INF/classes/");
            manifestcp.add((Object)"WEB-INF/classes/");
            for (ZipEntry entry : libs) {
                URI targetPath = new URI(null, entry.getName(), null);
                moduleContext.addInclude(targetPath, (ZipFile)warFile, entry);
                manifestcp.add((Object)entry.getName());
            }
            moduleContext.addManifestClassPath(warFile, RELATIVE_MODULE_BASE_URI);
            moduleContext.getGeneralData().put(ClassPathList.class, manifestcp);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying war", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for location of war entry", (Throwable)e);
        }
        finally {
            if (!module.isStandAlone()) {
                try {
                    moduleContext.flush();
                }
                catch (IOException e) {
                    throw new DeploymentException("Problem closing war context", (Throwable)e);
                }
            }
        }
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, repositories);
        }
    }

    protected void basicInitContext(EARContext earContext, Module module, XmlObject gerWebApp, boolean hasSecurityRealmName) throws DeploymentException {
        XmlObject[] securityElements;
        EARContext moduleContext = module.getEarContext();
        ClassPathList manifestcp = (ClassPathList)moduleContext.getGeneralData().get(ClassPathList.class);
        ModuleList moduleLocations = (ModuleList)module.getRootEarContext().getGeneralData().get(ModuleList.class);
        URI baseUri = URI.create(module.getTargetPath());
        URI resolutionUri = AbstractWebModuleBuilder.invertURI(baseUri);
        earContext.getCompleteManifestClassPath(module.getModuleFile(), baseUri, resolutionUri, manifestcp, moduleLocations);
        WebAppType webApp = (WebAppType)module.getSpecDD();
        if (!(webApp.getSecurityConstraintArray().length <= 0 && webApp.getSecurityRoleArray().length <= 0 || hasSecurityRealmName)) {
            throw new DeploymentException("web.xml for web app " + module.getName() + " includes security elements but Geronimo deployment plan is not provided or does not contain <security-realm-name> element necessary to configure security accordingly.");
        }
        if (hasSecurityRealmName) {
            earContext.setHasSecurity(true);
        }
        if ((securityElements = XmlBeansUtil.selectSubstitutionGroupElements((QName)SECURITY_QNAME, (XmlObject)gerWebApp)).length > 0 && !hasSecurityRealmName) {
            throw new DeploymentException("You have supplied a security configuration for web app " + module.getName() + " but no security-realm-name to allow login");
        }
        this.getNamingBuilders().buildEnvironment((XmlObject)webApp, module.getVendorDD(), module.getEnvironment());
        this.getNamingBuilders().initContext((XmlObject)webApp, gerWebApp, module);
        Map<String, String> servletNameToPathMap = this.buildServletNameToPathMap((WebAppType)module.getSpecDD(), ((WebModule)module).getContextRoot());
        Map sharedContext = module.getSharedContext();
        Iterator<WebServiceBuilder> i$ = this.webServiceBuilder.iterator();
        while (i$.hasNext()) {
            WebServiceBuilder aWebServiceBuilder;
            WebServiceBuilder serviceBuilder = aWebServiceBuilder = i$.next();
            serviceBuilder.findWebServices(module, false, servletNameToPathMap, module.getEnvironment(), sharedContext);
        }
        this.serviceBuilders.build(gerWebApp, (DeploymentContext)earContext, (DeploymentContext)module.getEarContext());
    }

    static URI invertURI(URI baseUri) {
        URI resolutionUri = URI.create(".");
        URI test = baseUri;
        while (!test.equals(RELATIVE_MODULE_BASE_URI)) {
            resolutionUri = resolutionUri.resolve(RELATIVE_MODULE_BASE_URI);
            test = test.resolve(RELATIVE_MODULE_BASE_URI);
        }
        return resolutionUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebAppDocument convertToServletSchema(XmlObject xmlObject) throws XmlException {
        block18: {
            String schemaLocationURL = "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd";
            String version = "2.5";
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toStartDoc();
                cursor.toFirstChild();
                if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                    SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    XmlBeansUtil.validateDD((XmlObject)result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                if ("http://java.sun.com/xml/ns/javaee".equals(cursor.getName().getNamespaceURI())) {
                    SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    XmlBeansUtil.validateDD((XmlObject)result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
                String publicId = xmlDocumentProperties.getDoctypePublicId();
                boolean is22 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId);
                if (!"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId) && !is22) break block18;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    moveable.toStartDoc();
                    moveable.toFirstChild();
                    SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                    cursor.toStartDoc();
                    cursor.toChild("http://java.sun.com/xml/ns/javaee", "web-app");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                    cursor.push();
                    if (cursor.toNextSibling(TAGLIB)) {
                        cursor.toPrevSibling();
                        moveable.toCursor(cursor);
                        cursor.beginElement("jsp-config", "http://java.sun.com/xml/ns/javaee");
                        while (moveable.toNextSibling(TAGLIB)) {
                            moveable.moveXml(cursor);
                        }
                    }
                    cursor.pop();
                    do {
                        String jspFile;
                        String name;
                        if (!"filter".equals(name = cursor.getName().getLocalPart()) && !"servlet".equals(name) && !"context-param".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                        while (cursor.toNextSibling("http://java.sun.com/xml/ns/javaee", "init-param")) {
                            cursor.push();
                            cursor.toFirstChild();
                            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
                            cursor.pop();
                        }
                        cursor.pop();
                        cursor.push();
                        if (cursor.toChild("http://java.sun.com/xml/ns/javaee", "jsp-file") && !(jspFile = cursor.getTextValue()).startsWith("/")) {
                            if (is22) {
                                cursor.setTextValue("/" + jspFile);
                            } else {
                                throw new XmlException("jsp-file does not start with / and this is not a 2.2 web app: " + jspFile);
                            }
                        }
                        cursor.pop();
                    } while (cursor.toNextSibling());
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(WebAppDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (WebAppDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (WebAppDocument)xmlObject;
    }

    protected ComponentPermissions buildSpecSecurityConfig(WebAppType webApp) {
        SpecSecurityBuilder builder = new SpecSecurityBuilder();
        return builder.buildSpecSecurityConfig(webApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureLocalJaspicProvider(AuthenticationWrapper authType, String contextPath, Module module, GBeanData securityFactoryData) throws DeploymentException, GBeanAlreadyExistsException {
        GBeanData authConfigProviderData;
        EARContext moduleContext;
        block22: {
            moduleContext = module.getEarContext();
            authConfigProviderData = null;
            AbstractName providerName = moduleContext.getNaming().createChildName(module.getModuleName(), "authConfigProvider", "GBean");
            try {
                if (authType.isSetConfigProvider()) {
                    authConfigProviderData = new GBeanData(providerName, AuthConfigProviderGBean.class);
                    XmlCursor xmlCursor = authType.getConfigProvider().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ConfigProviderType configProviderType = JaspiXmlUtil.loadConfigProvider((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeConfigProvider((ConfigProviderType)configProviderType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (authType.isSetServerAuthConfig()) {
                    authConfigProviderData = new GBeanData(providerName, ServerAuthConfigGBean.class);
                    XmlCursor xmlCursor = authType.getServerAuthConfig().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ServerAuthConfigType serverAuthConfigType = JaspiXmlUtil.loadServerAuthConfig((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeServerAuthConfig((ServerAuthConfigType)serverAuthConfigType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (authType.isSetServerAuthContext()) {
                    authConfigProviderData = new GBeanData(providerName, ServerAuthContextGBean.class);
                    XmlCursor xmlCursor = authType.getServerAuthContext().newCursor();
                    try {
                        InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                        ServerAuthContextType serverAuthContextType = JaspiXmlUtil.loadServerAuthContext((XMLStreamReader)reader);
                        StringWriter out = new StringWriter();
                        JaspiXmlUtil.writeServerAuthContext((ServerAuthContextType)serverAuthContextType, (Writer)out);
                        authConfigProviderData.setAttribute("config", (Object)out.toString());
                        break block22;
                    }
                    finally {
                        xmlCursor.dispose();
                    }
                }
                if (!authType.isSetServerAuthModule()) break block22;
                authConfigProviderData = new GBeanData(providerName, ServerAuthModuleGBean.class);
                XmlCursor xmlCursor = authType.getServerAuthModule().newCursor();
                try {
                    InternWrapper reader = new InternWrapper(xmlCursor.newXMLStreamReader());
                    AuthModuleType authModuleType = JaspiXmlUtil.loadServerAuthModule((XMLStreamReader)reader);
                    StringWriter out = new StringWriter();
                    JaspiXmlUtil.writeServerAuthModule((AuthModuleType)authModuleType, (Writer)out);
                    authConfigProviderData.setAttribute("config", (Object)out.toString());
                    authConfigProviderData.setAttribute("messageLayer", (Object)"Http");
                    authConfigProviderData.setAttribute("appContext", (Object)contextPath);
                    authConfigProviderData.setAttribute("authenticationID", (Object)contextPath);
                }
                finally {
                    xmlCursor.dispose();
                }
            }
            catch (ParserConfigurationException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (IOException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (SAXException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (JAXBException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new DeploymentException("Could not read auth config", (Throwable)e);
            }
        }
        if (authConfigProviderData != null) {
            moduleContext.addGBean(authConfigProviderData);
            securityFactoryData.addDependency(authConfigProviderData.getAbstractName());
        }
    }

    protected static void check(WebAppType webApp) throws DeploymentException {
        AbstractWebModuleBuilder.checkURLPattern(webApp);
        AbstractWebModuleBuilder.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebAppType webApp) throws DeploymentException {
        SecurityConstraintType[] constraints;
        ServletMappingType[] servletMappings;
        FilterMappingType[] filterMappings;
        for (FilterMappingType filterMapping : filterMappings = webApp.getFilterMappingArray()) {
            UrlPatternType[] urlPatterns = filterMapping.getUrlPatternArray();
            for (int j = 0; urlPatterns != null && j < urlPatterns.length; ++j) {
                AbstractWebModuleBuilder.checkString(urlPatterns[j].getStringValue().trim());
            }
        }
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            UrlPatternType[] urlPatterns = servletMapping.getUrlPatternArray();
            for (int j = 0; urlPatterns != null && j < urlPatterns.length; ++j) {
                AbstractWebModuleBuilder.checkString(urlPatterns[j].getStringValue().trim());
            }
        }
        for (SecurityConstraintType constraint : constraints = webApp.getSecurityConstraintArray()) {
            WebResourceCollectionType[] collections;
            for (WebResourceCollectionType collection : collections = constraint.getWebResourceCollectionArray()) {
                UrlPatternType[] patterns;
                for (UrlPatternType pattern : patterns = collection.getUrlPatternArray()) {
                    AbstractWebModuleBuilder.checkString(pattern.getStringValue().trim());
                }
            }
        }
    }

    protected static void checkString(String pattern) throws DeploymentException {
        if (pattern.indexOf(13) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain CR(#xD)");
        }
        if (pattern.indexOf(10) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain LF(#xA)");
        }
    }

    private static void checkMultiplicities(WebAppType webApp) throws DeploymentException {
        if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException("Multiple <session-config> elements found");
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException("Multiple <jsp-config> elements found");
        }
        if (webApp.getLoginConfigArray().length > 1) {
            throw new DeploymentException("Multiple <login-config> elements found");
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    protected ClassFinder createWebAppClassFinder(WebAppType webApp, WebModule webModule) throws DeploymentException {
        ClassLoader classLoader = webModule.getEarContext().getClassLoader();
        return AbstractWebModuleBuilder.createWebAppClassFinder(webApp, classLoader);
    }

    public static ClassFinder createWebAppClassFinder(WebAppType webApp, ClassLoader classLoader) throws DeploymentException {
        FilterType[] filters;
        ListenerType[] listeners;
        ServletType[] servlets;
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ServletType servlet : servlets = webApp.getServletArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = servlet.getServletClass();
            if (cls == null) continue;
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load servlet class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (ListenerType listener : listeners = webApp.getListenerArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = listener.getListenerClass();
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load listener class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        for (FilterType filter : filters = webApp.getFilterArray()) {
            Class<?> clas;
            FullyQualifiedClassType cls = filter.getFilterClass();
            try {
                clas = classLoader.loadClass(cls.getStringValue());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AbstractWebModuleBuilder: Could not load filter class: " + cls.getStringValue(), (Throwable)e);
            }
            AbstractWebModuleBuilder.addClass(classes, clas);
        }
        try {
            return new ClassFinder(classes);
        }
        catch (NoClassDefFoundError e) {
            throw new DeploymentException("Classloader for " + webApp.getId() + "can't find " + e.getMessage(), (Throwable)e);
        }
    }

    private static void addClass(List<Class> classes, Class<?> clas) {
        while (clas != Object.class) {
            classes.add(clas);
            clas = clas.getSuperclass();
        }
    }

    protected void configureBasicWebModuleAttributes(WebAppType webApp, XmlObject vendorPlan, EARContext moduleContext, EARContext earContext, WebModule webModule, GBeanData webModuleData) throws DeploymentException {
        HashMap<NamingBuilder.Key, AbstractName> buildingContext = new HashMap<NamingBuilder.Key, AbstractName>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleContext.getModuleName());
        if (!webApp.getMetadataComplete()) {
            webModule.setClassFinder(this.createWebAppClassFinder(webApp, webModule));
            SecurityAnnotationHelper.processAnnotations((WebAppType)webApp, (ClassFinder)webModule.getClassFinder());
        }
        this.getNamingBuilders().buildNaming((XmlObject)webApp, vendorPlan, (Module)webModule, buildingContext);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(buildingContext);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(buildingContext);
        webModule.getSharedContext().put("WEB_APP_DATA", webModuleData);
        webModule.getSharedContext().put(NamingBuilder.JNDI_KEY, compContext);
        webModule.getSharedContext().put(NamingBuilder.INJECTION_KEY, holder);
        if (moduleContext.getServerName() != null) {
            webModuleData.setReferencePattern("J2EEServer", moduleContext.getServerName());
        }
        if (!webModule.isStandAlone()) {
            webModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
        }
        webModuleData.setAttribute("holder", (Object)holder);
        if (earContext != moduleContext) {
            this.addGBeanDependencies(earContext, webModuleData);
        }
        webModuleData.setAttribute("componentContext", (Object)compContext);
        webModuleData.setReferencePattern("TransactionManager", moduleContext.getTransactionManagerName());
        webModuleData.setReferencePattern("TrackedConnectionAssociator", moduleContext.getConnectionTrackerName());
    }

    static {
        SECURITY_QNAME = GerSecurityDocument.type.getDocumentElementName();
        RELATIVE_MODULE_BASE_URI = URI.create("../");
        MANAGED_CONNECTION_FACTORY_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        ADMIN_OBJECT_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "JCAAdminObject"));
        STATELESS_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatelessSessionBean"));
        STATEFUL_SESSION_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "StatefulSessionBean"));
        ENTITY_BEAN_PATTERN = new AbstractNameQuery(null, Collections.singletonMap("j2eeType", "EntityBean"));
    }

    private static class InternWrapper
    implements XMLStreamReader {
        private final XMLStreamReader delegate;

        private InternWrapper(XMLStreamReader delegate) {
            this.delegate = delegate;
        }

        public void close() throws XMLStreamException {
            this.delegate.close();
        }

        public int getAttributeCount() {
            return this.delegate.getAttributeCount();
        }

        public String getAttributeLocalName(int i) {
            return this.delegate.getAttributeLocalName(i);
        }

        public QName getAttributeName(int i) {
            return this.delegate.getAttributeName(i);
        }

        public String getAttributeNamespace(int i) {
            return this.delegate.getAttributeNamespace(i);
        }

        public String getAttributePrefix(int i) {
            return this.delegate.getAttributePrefix(i);
        }

        public String getAttributeType(int i) {
            return this.delegate.getAttributeType(i);
        }

        public String getAttributeValue(int i) {
            return this.delegate.getAttributeValue(i);
        }

        public String getAttributeValue(String s, String s1) {
            return this.delegate.getAttributeValue(s, s1);
        }

        public String getCharacterEncodingScheme() {
            return this.delegate.getCharacterEncodingScheme();
        }

        public String getElementText() throws XMLStreamException {
            return this.delegate.getElementText();
        }

        public String getEncoding() {
            return this.delegate.getEncoding();
        }

        public int getEventType() {
            return this.delegate.getEventType();
        }

        public String getLocalName() {
            return this.delegate.getLocalName().intern();
        }

        public Location getLocation() {
            return this.delegate.getLocation();
        }

        public QName getName() {
            return this.delegate.getName();
        }

        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public int getNamespaceCount() {
            return this.delegate.getNamespaceCount();
        }

        public String getNamespacePrefix(int i) {
            return this.delegate.getNamespacePrefix(i);
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI().intern();
        }

        public String getNamespaceURI(int i) {
            return this.delegate.getNamespaceURI(i);
        }

        public String getNamespaceURI(String s) {
            return this.delegate.getNamespaceURI(s);
        }

        public String getPIData() {
            return this.delegate.getPIData();
        }

        public String getPITarget() {
            return this.delegate.getPITarget();
        }

        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        public Object getProperty(String s) throws IllegalArgumentException {
            return this.delegate.getProperty(s);
        }

        public String getText() {
            return this.delegate.getText();
        }

        public char[] getTextCharacters() {
            return this.delegate.getTextCharacters();
        }

        public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
            return this.delegate.getTextCharacters(i, chars, i1, i2);
        }

        public int getTextLength() {
            return this.delegate.getTextLength();
        }

        public int getTextStart() {
            return this.delegate.getTextStart();
        }

        public String getVersion() {
            return this.delegate.getVersion();
        }

        public boolean hasName() {
            return this.delegate.hasName();
        }

        public boolean hasNext() throws XMLStreamException {
            return this.delegate.hasNext();
        }

        public boolean hasText() {
            return this.delegate.hasText();
        }

        public boolean isAttributeSpecified(int i) {
            return this.delegate.isAttributeSpecified(i);
        }

        public boolean isCharacters() {
            return this.delegate.isCharacters();
        }

        public boolean isEndElement() {
            return this.delegate.isEndElement();
        }

        public boolean isStandalone() {
            return this.delegate.isStandalone();
        }

        public boolean isStartElement() {
            return this.delegate.isStartElement();
        }

        public boolean isWhiteSpace() {
            return this.delegate.isWhiteSpace();
        }

        public int next() throws XMLStreamException {
            return this.delegate.next();
        }

        public int nextTag() throws XMLStreamException {
            return this.delegate.nextTag();
        }

        public void require(int i, String s, String s1) throws XMLStreamException {
            this.delegate.require(i, s, s1);
        }

        public boolean standaloneSet() {
            return this.delegate.standaloneSet();
        }
    }
}

