/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web25.deployment.security.HTTPMethods;
import org.apache.geronimo.web25.deployment.security.URLPattern;
import org.apache.geronimo.web25.deployment.security.UncheckedItem;
import org.apache.geronimo.xbeans.javaee.RoleNameType;
import org.apache.geronimo.xbeans.javaee.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee.SecurityRoleRefType;
import org.apache.geronimo.xbeans.javaee.SecurityRoleType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.UrlPatternType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.geronimo.xbeans.javaee.WebResourceCollectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecSecurityBuilder {
    private final Set<String> securityRoles = new HashSet<String>();
    private final Map<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedResourcePatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedUserPatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<String, URLPattern> excludedPatterns = new HashMap<String, URLPattern>();
    private final Map<String, Map<String, URLPattern>> rolesPatterns = new HashMap<String, Map<String, URLPattern>>();
    private final Set<URLPattern> allSet = new HashSet<URLPattern>();
    private final Map<String, URLPattern> allMap = new HashMap<String, URLPattern>();
    private boolean useExcluded = true;
    private final RecordingPolicyConfiguration policyConfiguration = new RecordingPolicyConfiguration(true);

    public ComponentPermissions buildSpecSecurityConfig(WebAppType webApp) {
        this.collectRoleNames(webApp.getSecurityRoleArray());
        try {
            for (ServletType servletType : webApp.getServletArray()) {
                this.processRoleRefPermissions(servletType);
            }
            this.addUnmappedJSPPermissions();
            this.analyzeSecurityConstraints(webApp.getSecurityConstraintArray());
            this.removeExcludedDups();
            return this.buildComponentPermissions();
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    public void analyzeSecurityConstraints(SecurityConstraintType[] securityConstraintArray) {
        for (SecurityConstraintType securityConstraintType : securityConstraintArray) {
            Map<String, URLPattern> currentPatterns = null;
            HashSet<String> roleNames = null;
            if (securityConstraintType.isSetAuthConstraint()) {
                if (securityConstraintType.getAuthConstraint().getRoleNameArray().length == 0) {
                    currentPatterns = this.excludedPatterns;
                } else {
                    roleNames = new HashSet<String>();
                    for (RoleNameType roleName : securityConstraintType.getAuthConstraint().getRoleNameArray()) {
                        roleNames.add(roleName.getStringValue().trim());
                    }
                    if (roleNames.remove("*")) {
                        roleNames.addAll(this.securityRoles);
                    }
                }
            } else {
                currentPatterns = this.uncheckedPatterns;
            }
            String transport = "";
            if (securityConstraintType.isSetUserDataConstraint()) {
                transport = securityConstraintType.getUserDataConstraint().getTransportGuarantee().getStringValue().trim().toUpperCase();
            }
            boolean isRolebasedPatten = currentPatterns == null;
            for (WebResourceCollectionType webResourceCollectionType : securityConstraintType.getWebResourceCollectionArray()) {
                for (UrlPatternType urlPatternType : webResourceCollectionType.getUrlPatternArray()) {
                    String url = urlPatternType.getStringValue().trim();
                    if (isRolebasedPatten) {
                        for (String roleName : roleNames) {
                            Map<String, URLPattern> currentRolePatterns = this.rolesPatterns.get(roleName);
                            if (currentRolePatterns == null) {
                                currentRolePatterns = new HashMap<String, URLPattern>();
                                this.rolesPatterns.put(roleName, currentRolePatterns);
                            }
                            this.analyzeURLPattern(url, webResourceCollectionType.getHttpMethodArray(), transport, currentRolePatterns);
                        }
                    } else {
                        this.analyzeURLPattern(url, webResourceCollectionType.getHttpMethodArray(), transport, currentPatterns);
                    }
                    URLPattern allPattern = this.allMap.get(url);
                    if (allPattern == null) {
                        allPattern = new URLPattern(url);
                        this.allSet.add(allPattern);
                        this.allMap.put(url, allPattern);
                    }
                    this.analyzeURLPattern(url, webResourceCollectionType.getHttpMethodArray(), transport, this.allMap);
                }
            }
        }
    }

    private void analyzeURLPattern(String urlPattern, String[] httpMethods, String transport, Map<String, URLPattern> currentPatterns) {
        URLPattern pattern = currentPatterns.get(urlPattern);
        if (pattern == null) {
            pattern = new URLPattern(urlPattern);
            currentPatterns.put(urlPattern, pattern);
        }
        if (httpMethods.length == 0) {
            pattern.addMethod("");
        } else {
            for (String httpMethod : httpMethods) {
                if (httpMethod == null) continue;
                pattern.addMethod(httpMethod.trim());
            }
        }
        pattern.setTransport(transport);
    }

    public void removeExcludedDups() {
        for (Map.Entry<String, URLPattern> excluded : this.excludedPatterns.entrySet()) {
            String url = excluded.getKey();
            URLPattern pattern = excluded.getValue();
            this.removeExcluded(url, pattern, this.uncheckedPatterns);
            for (Map<String, URLPattern> rolePatterns : this.rolesPatterns.values()) {
                this.removeExcluded(url, pattern, rolePatterns);
            }
        }
    }

    private void removeExcluded(String url, URLPattern pattern, Map<String, URLPattern> patterns) {
        URLPattern testPattern = patterns.get(url);
        if (testPattern != null && !testPattern.removeMethods(pattern)) {
            patterns.remove(url);
        }
    }

    public ComponentPermissions buildComponentPermissions() throws PolicyContextException {
        HTTPMethods methods;
        String name;
        if (this.useExcluded) {
            for (URLPattern uRLPattern : this.excludedPatterns.values()) {
                name = uRLPattern.getQualifiedPattern(this.allSet);
                String actions = uRLPattern.getMethods();
                this.policyConfiguration.addToExcludedPolicy((Permission)new WebResourcePermission(name, actions));
                this.policyConfiguration.addToExcludedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
        }
        for (Map.Entry entry : this.rolesPatterns.entrySet()) {
            HashSet<URLPattern> currentRolePatterns = new HashSet<URLPattern>(((Map)entry.getValue()).values());
            for (URLPattern pattern : ((Map)entry.getValue()).values()) {
                String name2 = pattern.getQualifiedPattern(currentRolePatterns);
                String actions = pattern.getMethods();
                WebResourcePermission permission = new WebResourcePermission(name2, actions);
                this.policyConfiguration.addToRole((String)entry.getKey(), (Permission)permission);
                HTTPMethods methods2 = pattern.getHTTPMethods();
                int transportType = pattern.getTransport();
                this.addOrUpdatePattern(this.uncheckedUserPatterns, name2, methods2, transportType);
            }
        }
        for (URLPattern uRLPattern : this.uncheckedPatterns.values()) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            methods = uRLPattern.getHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods, 0);
            int transportType = uRLPattern.getTransport();
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods, transportType);
        }
        for (URLPattern uRLPattern : this.allSet) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            methods = uRLPattern.getComplementedHTTPMethods();
            if (methods.isNone()) continue;
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods, 0);
        }
        URLPattern pattern = new URLPattern("/");
        if (!this.allSet.contains(pattern)) {
            String string = pattern.getQualifiedPattern(this.allSet);
            HTTPMethods methods3 = pattern.getComplementedHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, string, methods3, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, string, methods3, 0);
        }
        for (UncheckedItem item : this.uncheckedResourcePatterns.keySet()) {
            methods = this.uncheckedResourcePatterns.get(item);
            String actions = URLPattern.getMethodsWithTransport(methods, item.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebResourcePermission(item.getName(), actions));
        }
        for (UncheckedItem item : this.uncheckedUserPatterns.keySet()) {
            methods = this.uncheckedUserPatterns.get(item);
            String actions = URLPattern.getMethodsWithTransport(methods, item.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebUserDataPermission(item.getName(), actions));
        }
        return this.policyConfiguration.getComponentPermissions();
    }

    private void addOrUpdatePattern(Map<UncheckedItem, HTTPMethods> patternMap, String name, HTTPMethods actions, int transportType) {
        UncheckedItem item = new UncheckedItem(name, transportType);
        HTTPMethods existingActions = patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, existingActions.add(actions));
            return;
        }
        patternMap.put(item, new HTTPMethods(actions, false));
    }

    protected void processRoleRefPermissions(ServletType servletType) throws PolicyContextException {
        String servletName = servletType.getServletName().getStringValue().trim();
        SecurityRoleRefType[] securityRoleRefTypeArray = servletType.getSecurityRoleRefArray();
        HashSet<String> unmappedRoles = new HashSet<String>(this.securityRoles);
        for (SecurityRoleRefType securityRoleRefType : securityRoleRefTypeArray) {
            String roleName = securityRoleRefType.getRoleName().getStringValue().trim();
            String roleLink = securityRoleRefType.getRoleLink().getStringValue().trim();
            this.policyConfiguration.addToRole(roleLink, (Permission)new WebRoleRefPermission(servletName, roleName));
            unmappedRoles.remove(roleName);
        }
        for (String roleName : unmappedRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName));
        }
    }

    protected void addUnmappedJSPPermissions() throws PolicyContextException {
        for (String roleName : this.securityRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission("", roleName));
        }
    }

    protected void collectRoleNames(SecurityRoleType[] securityRoles) {
        for (SecurityRoleType securityRole : securityRoles) {
            this.securityRoles.add(securityRole.getRoleName().getStringValue().trim());
        }
    }

    private static class RecordingPolicyConfiguration
    implements PolicyConfiguration {
        private final PermissionCollection excludedPermissions = new Permissions();
        private final PermissionCollection uncheckedPermissions = new Permissions();
        private final Map<String, PermissionCollection> rolePermissions = new HashMap<String, PermissionCollection>();
        private final StringBuilder audit;

        private RecordingPolicyConfiguration(boolean audit) {
            this.audit = audit ? new StringBuilder() : null;
        }

        public String getContextID() throws PolicyContextException {
            return null;
        }

        public void addToRole(String roleName, PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToRole(String roleName, Permission permission) throws PolicyContextException {
            PermissionCollection permissionsForRole;
            if (this.audit != null) {
                this.audit.append("Role: ").append(roleName).append(" -> ").append(permission).append('\n');
            }
            if ((permissionsForRole = this.rolePermissions.get(roleName)) == null) {
                permissionsForRole = new Permissions();
                this.rolePermissions.put(roleName, permissionsForRole);
            }
            permissionsForRole.add(permission);
        }

        public void addToUncheckedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Unchecked -> ").append(permission).append('\n');
            }
            this.uncheckedPermissions.add(permission);
        }

        public void addToExcludedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Excluded -> ").append(permission).append('\n');
            }
            this.excludedPermissions.add(permission);
        }

        public void removeRole(String roleName) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeUncheckedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeExcludedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void delete() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void commit() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public boolean inService() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public ComponentPermissions getComponentPermissions() {
            return new ComponentPermissions(this.excludedPermissions, this.uncheckedPermissions, this.rolePermissions);
        }

        public String getAudit() {
            if (this.audit == null) {
                return "no audit kept";
            }
            return this.audit.toString();
        }
    }
}

