/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.util.Encryption;
import org.apache.geronimo.util.SimpleEncryption;

public class EncryptionManager {
    private static final Map<String, Encryption> ENCRYPTORS = Collections.synchronizedMap(new HashMap());
    private static final String SIMPLE_ENCRYPTION_PREFIX = "{Simple}";
    private static String encryptionPrefix;

    public static synchronized void setEncryptionPrefix(String prefix, Encryption encryption) {
        if (SIMPLE_ENCRYPTION_PREFIX.equals(encryptionPrefix)) {
            encryptionPrefix = prefix;
        }
        ENCRYPTORS.put(prefix, encryption);
    }

    public static String encrypt(Serializable source) {
        if (source instanceof String) {
            String sourceString = (String)((Object)source);
            if (sourceString.startsWith(encryptionPrefix)) {
                return (String)((Object)source);
            }
            if (sourceString.startsWith("{")) {
                source = EncryptionManager.decrypt(sourceString);
            }
        }
        Encryption encryption = ENCRYPTORS.get(encryptionPrefix);
        return encryptionPrefix + encryption.encrypt(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable decrypt(String source) {
        String prefix = null;
        Encryption encryption = null;
        Map<String, Encryption> map = ENCRYPTORS;
        synchronized (map) {
            for (Map.Entry<String, Encryption> entry : ENCRYPTORS.entrySet()) {
                prefix = entry.getKey();
                if (!source.startsWith(prefix)) continue;
                encryption = entry.getValue();
                break;
            }
        }
        if (encryption != null) {
            return encryption.decrypt(source.substring(prefix.length()));
        }
        return source;
    }

    static {
        ENCRYPTORS.put(SIMPLE_ENCRYPTION_PREFIX, SimpleEncryption.INSTANCE);
        ENCRYPTORS.put("{Standard}", SimpleEncryption.INSTANCE);
        encryptionPrefix = SIMPLE_ENCRYPTION_PREFIX;
    }
}

