/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.geronimo.tomcat.model.InterceptorType;
import org.apache.geronimo.tomcat.model.MembershipType;
import org.apache.geronimo.tomcat.model.ReceiverType;
import org.apache.geronimo.tomcat.model.SenderType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ChannelType")
public class ChannelType {
    @XmlAttribute
    protected String className = GroupChannel.class.getName();
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    @XmlElement(name="Membership")
    protected MembershipType membership;
    @XmlElement(name="Interceptor")
    protected List<InterceptorType> interceptor;
    @XmlElement(name="Receiver")
    protected ReceiverType receiver;
    @XmlElement(name="Sender")
    protected SenderType sender;

    public Channel getChannel(ClassLoader cl) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Channel channel = (Channel)recipe.create(cl);
        for (InterceptorType interceptorType : this.getInterceptor()) {
            channel.addInterceptor(interceptorType.getInterceptor(cl));
        }
        if (channel instanceof ManagedChannel) {
            ManagedChannel managedChannel = (ManagedChannel)channel;
            if (this.sender != null) {
                managedChannel.setChannelSender(this.sender.getSender(cl));
            }
            if (this.receiver != null) {
                managedChannel.setChannelReceiver(this.receiver.getReceiver(cl));
            }
            if (this.membership != null) {
                managedChannel.setMembershipService(this.membership.getMembership(cl));
            }
        }
        return channel;
    }

    public String getClassName() {
        return this.className;
    }

    public MembershipType getMembership() {
        return this.membership;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ReceiverType getReceiver() {
        return this.receiver;
    }

    public SenderType getSender() {
        return this.sender;
    }

    public List<InterceptorType> getInterceptor() {
        if (this.interceptor == null) {
            this.interceptor = new ArrayList<InterceptorType>();
        }
        return this.interceptor;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMembership(MembershipType membership) {
        this.membership = membership;
    }

    public void setReceiver(ReceiverType receiver) {
        this.receiver = receiver;
    }

    public void setSender(SenderType sender) {
        this.sender = sender;
    }
}

