/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.Stack;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.core.StandardWrapper;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;
import org.apache.geronimo.tomcat.security.jacc.JACCRealm;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchListener
implements InstanceListener {
    private static final Logger log = LoggerFactory.getLogger(DispatchListener.class);
    private static ThreadLocal<Stack<BeforeAfterContext>> currentContext = new ThreadLocal<Stack<BeforeAfterContext>>(){

        @Override
        protected Stack<BeforeAfterContext> initialValue() {
            return new Stack<BeforeAfterContext>();
        }
    };

    public void instanceEvent(InstanceEvent event) {
        Container parent;
        if (event.getType().equals("beforeService")) {
            String oldWrapperName = JACCRealm.setRequestWrapperName(event.getWrapper().getName());
            BeforeAfterContext beforeAfterContext = new BeforeAfterContext(1);
            beforeAfterContext.contexts[0] = oldWrapperName;
            currentContext.get().push(beforeAfterContext);
        }
        if (event.getType().equals("afterService")) {
            JACCRealm.setRequestWrapperName((String)DispatchListener.currentContext.get().pop().contexts[0]);
        }
        if (event.getType().equals("beforeDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.beforeDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
        if (event.getType().equals("afterDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.afterDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
    }

    private void beforeDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack<BeforeAfterContext> stack = currentContext.get();
            BeforeAfterContext beforeAfterContext = new BeforeAfterContext(webContext.getContextCount() + 2);
            String wrapperName = this.getWrapperName(request, webContext);
            beforeAfterContext.contexts[webContext.getContextCount()] = JACCRealm.setRequestWrapperName(wrapperName);
            beforeAfterContext.contexts[webContext.getContextCount() + 1] = PolicyContext.getContextID();
            PolicyContext.setContextID((String)webContext.getPolicyContextId());
            beforeAfter.before(beforeAfterContext, request, response, 1);
            stack.push(beforeAfterContext);
        }
    }

    private void afterDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack<BeforeAfterContext> stack = currentContext.get();
            BeforeAfterContext beforeAfterContext = stack.pop();
            beforeAfter.after(beforeAfterContext, request, response, 1);
            JACCRealm.setRequestWrapperName((String)beforeAfterContext.contexts[webContext.getContextCount()]);
            PolicyContext.setContextID((String)((String)beforeAfterContext.contexts[webContext.getContextCount() + 1]));
        }
    }

    private String getWrapperName(ServletRequest request, GeronimoStandardContext webContext) {
        MappingData mappingData = new MappingData();
        Mapper mapper = webContext.getMapper();
        MessageBytes mb = MessageBytes.newInstance();
        String dispatchPath = (String)request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        mb.setString(webContext.getName() + dispatchPath);
        try {
            mapper.map(mb, mappingData);
            StandardWrapper wrapper = (StandardWrapper)mappingData.wrapper;
            return wrapper.getName();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

