/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;

public class RequestListenerBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int index;
    private final GeronimoStandardContext standardContext;

    public RequestListenerBeforeAfter(BeforeAfter next, int index, GeronimoStandardContext standardContext) {
        this.next = next;
        this.index = index;
        this.standardContext = standardContext;
    }

    @Override
    public void before(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        DispatcherType dispatcherType;
        if (httpRequest != null && httpResponse != null && ((dispatcherType = httpRequest.getDispatcherType()) == DispatcherType.REQUEST || dispatcherType == DispatcherType.FORWARD && this.standardContext.getFireRequestListenersOnForwards())) {
            this.standardContext.fireRequestInitEventInBeforeAfter(httpRequest);
        }
        if (this.next != null) {
            this.next.before(beforeAfterContext, httpRequest, httpResponse, dispatch);
        }
    }

    @Override
    public void after(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        DispatcherType dispatcherType;
        if (httpRequest != null && httpResponse != null && ((dispatcherType = httpRequest.getDispatcherType()) == DispatcherType.REQUEST || dispatcherType == DispatcherType.FORWARD && this.standardContext.getFireRequestListenersOnForwards())) {
            this.standardContext.fireRequestDestroyEventInBeforeAfter(httpRequest);
        }
        if (this.next != null) {
            this.next.after(beforeAfterContext, httpRequest, httpResponse, dispatch);
        }
    }
}

