/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextConfig;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jaspi.IdentityService;
import org.apache.geronimo.security.jaspi.LoginService;
import org.apache.geronimo.security.jaspi.UserIdentity;
import org.apache.geronimo.security.jaspi.impl.GeronimoIdentityService;
import org.apache.geronimo.security.jaspi.impl.GeronimoLoginService;
import org.apache.geronimo.security.jaspi.impl.JaspicCallbackHandler;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.authentication.BasicAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.ClientCertAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.DigestAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.FormAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.GenericHeaderAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.NoneAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.SpnegoAuthenticator;
import org.apache.geronimo.tomcat.security.authentication.jaspic.JaspicAuthenticator;
import org.apache.geronimo.tomcat.security.jacc.JACCAuthorizer;
import org.apache.geronimo.tomcat.security.jacc.JACCRealm;
import org.apache.geronimo.tomcat.security.jacc.JACCSecurityValve;
import org.apache.geronimo.web.assembler.Assembler;
import org.apache.geronimo.web.info.ErrorPageInfo;
import org.apache.geronimo.web.info.LoginConfigInfo;
import org.apache.geronimo.web.info.SessionConfigInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public abstract class BaseGeronimoContextConfig
extends ContextConfig {
    private static final String MESSAGE_LAYER = "HttpServlet";
    private static final String POLICY_CONTEXT_ID_KEY = "javax.security.jacc.PolicyContext";
    private static Log log = LogFactory.getLog(BaseGeronimoContextConfig.class);
    private final WebAppInfo webAppInfo;

    public BaseGeronimoContextConfig(WebAppInfo webAppInfo) {
        this.webAppInfo = webAppInfo;
    }

    protected void init() {
        super.init();
    }

    protected void configureStart() {
        ServletContext servletContext = this.context.getServletContext();
        Assembler assembler = new Assembler();
        assembler.assemble(servletContext, this.webAppInfo);
        this.context.setDisplayName(this.webAppInfo.displayName);
        this.context.setDistributable(this.webAppInfo.distributable);
        for (ErrorPageInfo errorPageInfo : this.webAppInfo.errorPages) {
            ErrorPage errorPage = new ErrorPage();
            errorPage.setLocation(errorPageInfo.location);
            errorPage.setExceptionType(errorPageInfo.exceptionType);
            if (errorPageInfo.errorCode != null) {
                errorPage.setErrorCode(errorPageInfo.errorCode.intValue());
            }
            this.context.addErrorPage(errorPage);
        }
        for (Map.Entry entry : this.webAppInfo.localeEncodingMappings.entrySet()) {
            this.context.addLocaleEncodingMappingParameter((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : this.webAppInfo.mimeMappings.entrySet()) {
            this.context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : this.webAppInfo.welcomeFiles) {
            this.context.addWelcomeFile(string);
        }
        this.authenticatorConfig(this.webAppInfo.loginConfig);
        if (this.webAppInfo.sessionConfig != null) {
            SessionConfigInfo sessionConfig = this.webAppInfo.sessionConfig;
            if (sessionConfig.sessionTimeoutMinutes != null) {
                this.context.setSessionTimeout(sessionConfig.sessionTimeoutMinutes.intValue());
            }
            if (sessionConfig.sessionTrackingModes != null) {
                servletContext.setSessionTrackingModes((Set)sessionConfig.sessionTrackingModes);
            }
            if (sessionConfig.sessionCookieConfig != null) {
                SessionCookieConfig sessionCookieConfig = servletContext.getSessionCookieConfig();
                if (sessionConfig.sessionCookieConfig.name != null) {
                    sessionCookieConfig.setName(sessionConfig.sessionCookieConfig.name);
                }
                if (sessionConfig.sessionCookieConfig.comment != null) {
                    sessionCookieConfig.setComment(sessionConfig.sessionCookieConfig.comment);
                }
                if (sessionConfig.sessionCookieConfig.domain != null) {
                    sessionCookieConfig.setDomain(sessionConfig.sessionCookieConfig.domain);
                }
                if (sessionConfig.sessionCookieConfig.httpOnly != null) {
                    sessionCookieConfig.setHttpOnly(sessionConfig.sessionCookieConfig.httpOnly.booleanValue());
                }
                if (sessionConfig.sessionCookieConfig.maxAge != null) {
                    sessionCookieConfig.setMaxAge(sessionConfig.sessionCookieConfig.maxAge.intValue());
                }
                if (sessionConfig.sessionCookieConfig.path != null) {
                    sessionCookieConfig.setPath(sessionConfig.sessionCookieConfig.path);
                }
                if (sessionConfig.sessionCookieConfig.secure != null) {
                    sessionCookieConfig.setSecure(sessionConfig.sessionCookieConfig.secure.booleanValue());
                }
            }
        }
        this.context.setConfigured(true);
    }

    protected abstract void authenticatorConfig(LoginConfigInfo var1);

    protected void configureSecurity(StandardContext geronimoContext, String policyContextId, ConfigurationFactory configurationFactory, Subject defaultSubject, String authMethod, String realmName, String loginPage, String errorPage) {
        Authenticator authenticator;
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        GeronimoIdentityService identityService = new GeronimoIdentityService(defaultSubject);
        UserIdentity unauthenticatedIdentity = identityService.newUserIdentity(defaultSubject);
        GeronimoLoginService loginService = new GeronimoLoginService(configurationFactory, (IdentityService)identityService);
        AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
        RegistrationListener listener = new RegistrationListener(){

            public void notify(String layer, String appContext) {
            }
        };
        String appContext = "server " + geronimoContext.getPath();
        AuthConfigProvider authConfigProvider = authConfigFactory.getConfigProvider(MESSAGE_LAYER, appContext, listener);
        ServerAuthConfig serverAuthConfig = null;
        JaspicCallbackHandler callbackHandler = null;
        if (authConfigProvider != null) {
            callbackHandler = new JaspicCallbackHandler((LoginService)loginService);
            try {
                serverAuthConfig = authConfigProvider.getServerAuthConfig(MESSAGE_LAYER, appContext, (CallbackHandler)callbackHandler);
            }
            catch (AuthException e) {
                // empty catch block
            }
        }
        if (serverAuthConfig != null) {
            HashMap<String, String> authProperties = new HashMap<String, String>();
            authProperties.put(POLICY_CONTEXT_ID_KEY, policyContextId);
            Subject serviceSubject = new Subject();
            authenticator = new JaspicAuthenticator(serverAuthConfig, authProperties, serviceSubject, (CallbackHandler)callbackHandler, (IdentityService)identityService);
        } else {
            authenticator = "BASIC".equalsIgnoreCase(authMethod) ? new BasicAuthenticator((LoginService)loginService, realmName, unauthenticatedIdentity) : ("CLIENT-CERT".equalsIgnoreCase(authMethod) ? new ClientCertAuthenticator((LoginService)loginService, unauthenticatedIdentity) : ("DIGEST".equalsIgnoreCase(authMethod) ? new DigestAuthenticator((LoginService)loginService, realmName, unauthenticatedIdentity) : ("FORM".equalsIgnoreCase(authMethod) ? new FormAuthenticator((LoginService)loginService, unauthenticatedIdentity, loginPage, errorPage) : ("GENERIC".equalsIgnoreCase(authMethod) ? new GenericHeaderAuthenticator((LoginService)loginService, unauthenticatedIdentity) : ("SPNEGO".equalsIgnoreCase(authMethod) ? new SpnegoAuthenticator((LoginService)loginService, realmName, unauthenticatedIdentity) : new NoneAuthenticator(unauthenticatedIdentity))))));
        }
        AccessControlContext defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null);
        Authorizer authorizer = this.createAuthorizer(defaultAcc);
        JACCSecurityValve securityValve = new JACCSecurityValve(authenticator, authorizer, (IdentityService)identityService, policyContextId);
        geronimoContext.addValve((Valve)securityValve);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", new Object[]{authMethod}));
        }
        geronimoContext.setRealm((Realm)new JACCRealm());
    }

    protected Authorizer createAuthorizer(AccessControlContext defaultAcc) {
        return new JACCAuthorizer(defaultAcc);
    }

    protected void parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        super.parseWebXml(source, dest, fragment);
        dest.setMetadataComplete(true);
    }
}

