/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.valve;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;

public class DefaultSubjectValve
extends ValveBase {
    private final Subject defaultSubject;

    public DefaultSubjectValve(Subject defaultSubject) {
        super(true);
        this.defaultSubject = defaultSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Callers oldCallers = null;
        boolean setSubject = false;
        if (this.defaultSubject != null) {
            oldCallers = ContextManager.getCallers();
            boolean bl = setSubject = oldCallers == null || oldCallers.getCurrentCaller() == null;
        }
        if (setSubject) {
            ContextManager.setCallers((Subject)this.defaultSubject, (Subject)this.defaultSubject);
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                ContextManager.popCallers((Callers)oldCallers);
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }
}

